/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.apache.hc.client5.http.utils;

import am_libs.org.apache.hc.core5.annotation.Internal;
import java.net.IDN;

public class DnsUtils {
    private DnsUtils() {
    }

    private static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static String normalize(String s2) {
        int remaining;
        if (s2 == null) {
            return null;
        }
        int pos = 0;
        for (remaining = s2.length(); remaining > 0 && !DnsUtils.isUpper(s2.charAt(pos)); --remaining) {
            ++pos;
        }
        if (remaining > 0) {
            StringBuilder buf = new StringBuilder(s2.length());
            buf.append(s2, 0, pos);
            while (remaining > 0) {
                char c = s2.charAt(pos);
                if (DnsUtils.isUpper(c)) {
                    buf.append((char)(c + 32));
                } else {
                    buf.append(c);
                }
                ++pos;
                --remaining;
            }
            return buf.toString();
        }
        return s2;
    }

    @Internal
    public static String normalizeUnicode(String s2) {
        String decoded;
        if (s2 == null) {
            return null;
        }
        try {
            decoded = IDN.toUnicode(s2);
        }
        catch (IllegalArgumentException ignore) {
            decoded = s2;
        }
        return DnsUtils.normalize(decoded);
    }
}

