/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.pqc.crypto.sphincs;

import am_libs.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import am_libs.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import am_libs.org.bouncycastle.crypto.Digest;
import am_libs.org.bouncycastle.crypto.KeyGenerationParameters;
import am_libs.org.bouncycastle.pqc.crypto.sphincs.HashFunctions;
import am_libs.org.bouncycastle.pqc.crypto.sphincs.SPHINCS256KeyGenerationParameters;
import am_libs.org.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import am_libs.org.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import am_libs.org.bouncycastle.pqc.crypto.sphincs.Tree;
import java.security.SecureRandom;

public class SPHINCS256KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;
    private Digest treeDigest;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        this.treeDigest = ((SPHINCS256KeyGenerationParameters)keyGenerationParameters).getTreeDigest();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Tree.leafaddr leafaddr2 = new Tree.leafaddr();
        byte[] byArray = new byte[1088];
        this.random.nextBytes(byArray);
        byte[] byArray2 = new byte[1056];
        System.arraycopy(byArray, 32, byArray2, 0, 1024);
        leafaddr2.level = 11;
        leafaddr2.subtree = 0L;
        leafaddr2.subleaf = 0L;
        HashFunctions hashFunctions = new HashFunctions(this.treeDigest);
        Tree.treehash(hashFunctions, byArray2, 1024, 5, byArray, leafaddr2, byArray2, 0);
        return new AsymmetricCipherKeyPair(new SPHINCSPublicKeyParameters(byArray2, this.treeDigest.getAlgorithmName()), new SPHINCSPrivateKeyParameters(byArray, this.treeDigest.getAlgorithmName()));
    }
}

