/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.AttributeKey;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.ConfigTools;
import pl.skidam.automodpack_core.protocol.NetUtils;
import pl.skidam.automodpack_core.protocol.netty.TrafficShaper;
import pl.skidam.automodpack_core.protocol.netty.handler.ProtocolServerHandler;
import pl.skidam.automodpack_core.utils.AddressHelpers;
import pl.skidam.automodpack_core.utils.CustomThreadFactoryBuilder;
import pl.skidam.automodpack_core.utils.ObservableMap;

public class NettyServer {
    public static final AttributeKey<Boolean> USE_COMPRESSION = AttributeKey.valueOf((String)"useCompression");
    private final Map<Channel, String> connections = Collections.synchronizedMap(new HashMap());
    private final Map<String, Path> paths = Collections.synchronizedMap(new HashMap());
    private MultithreadEventLoopGroup eventLoopGroup;
    private ChannelFuture serverChannel;
    private Boolean shouldHost = false;
    private String certificateFingerprint;
    private SslContext sslCtx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Channel channel, String secret) {
        Map<Channel, String> map = this.connections;
        synchronized (map) {
            this.connections.put(channel, secret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Channel channel) {
        Map<Channel, String> map = this.connections;
        synchronized (map) {
            this.connections.remove(channel);
        }
    }

    public Map<Channel, String> getConnections() {
        return this.connections;
    }

    public String getCertificateFingerprint() {
        return this.certificateFingerprint;
    }

    public void addPaths(ObservableMap<String, Path> paths) {
        this.paths.putAll(paths.getMap());
        paths.addOnPutCallback(this.paths::put);
        paths.addOnRemoveCallback(this.paths::remove);
    }

    public void removePaths(ObservableMap<String, Path> paths) {
        paths.getMap().forEach(this.paths::remove);
    }

    public Optional<Path> getPath(String hash) {
        return Optional.ofNullable(this.paths.get(hash));
    }

    public Optional<ChannelFuture> start() {
        if (!GlobalVariables.serverConfig.modpackHost) {
            GlobalVariables.LOGGER.warn("Modpack hosting is disabled in config");
            return Optional.empty();
        }
        try {
            Class<EpollServerSocketChannel> socketChannelClass;
            X509Certificate cert;
            if (!Files.exists(GlobalVariables.serverCertFile, new LinkOption[0]) || !Files.exists(GlobalVariables.serverPrivateKeyFile, new LinkOption[0])) {
                KeyPair keyPair = NetUtils.generateKeyPair();
                X509Certificate cert2 = NetUtils.selfSign(keyPair);
                NetUtils.saveCertificate(cert2, GlobalVariables.serverCertFile);
                NetUtils.savePrivateKey(keyPair.getPrivate(), GlobalVariables.serverPrivateKeyFile);
            }
            if ((cert = NetUtils.loadCertificate(GlobalVariables.serverCertFile)) == null) {
                throw new IllegalStateException("Server certificate couldn't be loaded");
            }
            this.sslCtx = SslContextBuilder.forServer((File)GlobalVariables.serverCertFile.toFile(), (File)GlobalVariables.serverPrivateKeyFile.toFile()).sslProvider(SslProvider.JDK).protocols(new String[]{"TLSv1.3"}).ciphers(Arrays.asList("TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256")).build();
            this.certificateFingerprint = NetUtils.getFingerprint(cert);
            GlobalVariables.LOGGER.warn("Certificate fingerprint for client validation: {}", (Object)this.certificateFingerprint);
            if (!this.canStart()) {
                new TrafficShaper(null);
                return Optional.empty();
            }
            int port = GlobalVariables.serverConfig.hostPort;
            InetSocketAddress bindAddress = new InetSocketAddress("0.0.0.0", port);
            GlobalVariables.LOGGER.info("Starting modpack host server on {}", (Object)bindAddress);
            if (Epoll.isAvailable()) {
                socketChannelClass = EpollServerSocketChannel.class;
                this.eventLoopGroup = new EpollEventLoopGroup(new CustomThreadFactoryBuilder().setNameFormat("AutoModpack Epoll Server IO #%d").setDaemon(true).build());
            } else {
                socketChannelClass = NioServerSocketChannel.class;
                this.eventLoopGroup = new NioEventLoopGroup(new CustomThreadFactoryBuilder().setNameFormat("AutoModpack Server IO #%d").setDaemon(true).build());
            }
            new TrafficShaper((ScheduledExecutorService)this.eventLoopGroup);
            this.serverChannel = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(socketChannelClass)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ch.pipeline().addLast("automodpack", (ChannelHandler)new ProtocolServerHandler(NettyServer.this.sslCtx));
                }
            }).group((EventLoopGroup)this.eventLoopGroup).localAddress((SocketAddress)bindAddress)).bind().syncUninterruptibly();
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Failed to start Netty server", (Throwable)e);
            return Optional.empty();
        }
        return Optional.ofNullable(this.serverChannel);
    }

    public boolean shouldHost() {
        return this.shouldHost;
    }

    public boolean stop() {
        try {
            if (this.serverChannel == null) {
                if (this.shouldHost.booleanValue()) {
                    this.shouldHost = false;
                }
            } else {
                this.serverChannel.channel().close().sync();
            }
            TrafficShaper.close();
            if (this.eventLoopGroup != null) {
                this.eventLoopGroup.shutdownGracefully().sync();
            }
        }
        catch (InterruptedException e) {
            GlobalVariables.LOGGER.error("Interrupted server channel", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isRunning() {
        if (this.serverChannel == null) {
            return this.shouldHost;
        }
        return this.serverChannel.channel().isOpen();
    }

    public SslContext getSslCtx() {
        return this.sslCtx;
    }

    private boolean canStart() {
        if (this.isRunning() || !GlobalVariables.serverConfig.modpackHost) {
            return false;
        }
        if (this.paths.isEmpty()) {
            GlobalVariables.LOGGER.warn("No file to host. Can't start modpack host server.");
            return false;
        }
        if (GlobalVariables.serverConfig.hostModpackOnMinecraftPort) {
            this.shouldHost = true;
            GlobalVariables.LOGGER.info("Hosting modpack on Minecraft port");
            return false;
        }
        if (GlobalVariables.serverConfig.updateIpsOnEveryStart || GlobalVariables.serverConfig.hostIp == null || GlobalVariables.serverConfig.hostIp.isEmpty()) {
            String publicIp = AddressHelpers.getPublicIp();
            if (publicIp != null) {
                GlobalVariables.serverConfig.hostIp = publicIp;
                ConfigTools.save(GlobalVariables.serverConfigFile, GlobalVariables.serverConfig);
                GlobalVariables.LOGGER.warn("Setting Host IP to {}", (Object)GlobalVariables.serverConfig.hostIp);
            } else {
                GlobalVariables.LOGGER.error("Host IP isn't set in config, please change it manually! Couldn't get public IP");
                return false;
            }
        }
        if (GlobalVariables.serverConfig.updateIpsOnEveryStart || GlobalVariables.serverConfig.hostLocalIp == null || GlobalVariables.serverConfig.hostLocalIp.isEmpty()) {
            try {
                GlobalVariables.serverConfig.hostLocalIp = AddressHelpers.getLocalIp();
                ConfigTools.save(GlobalVariables.serverConfigFile, GlobalVariables.serverConfig);
                GlobalVariables.LOGGER.warn("Setting Host local IP to {}", (Object)GlobalVariables.serverConfig.hostLocalIp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.shouldHost = true;
        return true;
    }
}

