/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.Jsons;

public class CustomFileUtils {
    private static final byte[] smallDummyJar = new byte[]{80, 75, 3, 4, 20, 0, 8, 8, 8, 0, 89, 116, -44, 86, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 0, 4, 0, 77, 69, 84, 65, 45, 73, 78, 70, 47, 77, 65, 78, 73, 70, 69, 83, 84, 46, 77, 70, -2, -54, 0, 0, -13, 77, -52, -53, 76, 75, 45, 46, -47, 13, 75, 45, 42, -50, -52, -49, -77, 82, 48, -44, 51, -32, -27, -30, -27, 2, 0, 80, 75, 7, 8, -78, 127, 2, -18, 27, 0, 0, 0, 25, 0, 0, 0, 80, 75, 1, 2, 20, 0, 20, 0, 8, 8, 8, 0, 89, 116, -44, 86, -78, 127, 2, -18, 27, 0, 0, 0, 25, 0, 0, 0, 20, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 77, 69, 84, 65, 45, 73, 78, 70, 47, 77, 65, 78, 73, 70, 69, 83, 84, 46, 77, 70, -2, -54, 0, 0, 80, 75, 5, 6, 0, 0, 0, 0, 1, 0, 1, 0, 70, 0, 0, 0, 97, 0, 0, 0, 0, 0};
    private static final Path CWD = Path.of(System.getProperty("user.dir"), new String[0]);

    public static void executeOrder66(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (Files.isRegularFile(file, new LinkOption[0])) {
            CustomFileUtils.dummyIT(file);
        }
    }

    public static Path getPathFromCWD(String path) {
        return CustomFileUtils.getPath(CWD, path);
    }

    public static Path getPath(Path origin, String path) {
        if (origin == null) {
            throw new IllegalArgumentException("Origin path must not be null");
        }
        if (path == null || path.isBlank()) {
            return origin;
        }
        if ((path = path.replace('\\', '/')).startsWith("/")) {
            path = path.substring(1);
        }
        return origin.resolve(path).normalize();
    }

    public static void copyFile(Path source, Path destination) throws IOException {
        CustomFileUtils.setupFilePaths(destination);
        try (RandomAccessFile sourceFile = new RandomAccessFile(source.toFile(), "r");
             FileOutputStream destinationFile = new FileOutputStream(destination.toFile());){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = sourceFile.read(buffer)) != -1) {
                destinationFile.write(buffer, 0, bytesRead);
            }
            destinationFile.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setupFilePaths(Path file) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            if (!Files.exists(file.getParent(), new LinkOption[0])) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            file.toFile().createNewFile();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean compareFilesByteByByte(Path path, byte[] referenceBytes) {
        try {
            long fileSize = Files.size(path);
            if (fileSize != (long)referenceBytes.length) {
                return false;
            }
            try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "r");){
                byte[] buffer = new byte[8192];
                block8: while (true) {
                    int bytesRead;
                    if ((bytesRead = raf.read(buffer)) == -1) return true;
                    int i = 0;
                    while (true) {
                        if (i >= bytesRead) continue block8;
                        byte fileByte = buffer[i];
                        byte referenceByte = referenceBytes[i];
                        if (fileByte != referenceByte) {
                            boolean bl = false;
                            return bl;
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String formatPath(Path modpackFile, Path modpackPath) {
        if (modpackPath == null || modpackFile == null) {
            throw new IllegalArgumentException("Arguments are null - modpackPath: " + String.valueOf(modpackPath) + ", modpackFile: " + String.valueOf(modpackFile));
        }
        String modpackFileStr = modpackFile.normalize().toString();
        String modpackFileStrAbs = modpackFile.toAbsolutePath().normalize().toString();
        String modpackPathStrAbs = modpackPath.toAbsolutePath().normalize().toString();
        String cwdStrAbs = Path.of(System.getProperty("user.dir"), new String[0]).toAbsolutePath().normalize().toString();
        Object formattedFile = modpackFileStr;
        if (modpackFileStrAbs.contains(modpackPathStrAbs)) {
            formattedFile = modpackFileStrAbs.replace(modpackPathStrAbs, "");
        } else if (modpackFileStrAbs.contains(cwdStrAbs)) {
            formattedFile = modpackFileStrAbs.replace(cwdStrAbs, "");
        } else if (!modpackFileStrAbs.equals(modpackFileStr)) {
            GlobalVariables.LOGGER.error("File: {} ({}) is not in modpack directory: {} ({}) or current working directory: {}", (Object)modpackFileStr, (Object)modpackFileStrAbs, (Object)modpackPath, (Object)modpackPathStrAbs, (Object)cwdStrAbs);
        }
        formattedFile = ((String)formattedFile).replace(File.separator, "/");
        if (!((String)formattedFile).startsWith("/")) {
            formattedFile = "/" + (String)formattedFile;
        }
        return formattedFile;
    }

    public static void deleteDummyFiles(Path directory, Set<Jsons.ModpackContentFields.ModpackContentItem> ignoreList) {
        if (directory == null || ignoreList == null) {
            return;
        }
        try (Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);){
            stream.filter(path -> !CustomFileUtils.shouldIgnore(path, ignoreList)).forEach(path -> {
                if (CustomFileUtils.compareFilesByteByByte(path, smallDummyJar)) {
                    CustomFileUtils.executeOrder66(path);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean shouldIgnore(Path file, Set<Jsons.ModpackContentFields.ModpackContentItem> ignoreList) {
        if (ignoreList == null) {
            return false;
        }
        String modpackFile = CustomFileUtils.formatPath(file, Objects.requireNonNullElse(GlobalVariables.selectedModpackDir, GlobalVariables.hostContentModpackDir));
        for (Jsons.ModpackContentFields.ModpackContentItem item : ignoreList) {
            if (!item.file.equals(modpackFile)) continue;
            return true;
        }
        return false;
    }

    public static void dummyIT(Path file) {
        try (FileOutputStream fos = new FileOutputStream(file.toFile());){
            fos.write(smallDummyJar);
            fos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getHash(Path file) {
        try {
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                return null;
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            try (RandomAccessFile raf = new RandomAccessFile(file.toFile(), "r");){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = raf.read(buffer)) != -1) {
                    digest.update(buffer, 0, bytesRead);
                }
            }
            byte[] hash = digest.digest();
            return HexFormat.of().formatHex(hash);
        }
        catch (UnsupportedOperationException e) {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        digest.update(buffer, 0, bytesRead);
                    }
                }
                byte[] hash = digest.digest();
                return HexFormat.of().formatHex(hash);
            }
            catch (Exception ex) {
                e.printStackTrace();
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Failed to get hash of file: {}", (Object)file, (Object)e);
        }
        return null;
    }

    public static String getCurseforgeMurmurHash(Path file) throws IOException {
        char b;
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        int m4 = 1540483477;
        int r = 24;
        long k = 0L;
        int seed = 1;
        int shift = 0;
        long length = 0L;
        try (RandomAccessFile raf = new RandomAccessFile(file.toFile(), "r");){
            int bytesRead;
            byte[] buffer = new byte[8128];
            while ((bytesRead = raf.read(buffer)) != -1) {
                for (int i = 0; i < bytesRead; ++i) {
                    b = (char)buffer[i];
                    if (b == '\t' || b == '\n' || b == '\r' || b == ' ') continue;
                    ++length;
                }
            }
        }
        long h2 = (long)seed ^ length;
        try (RandomAccessFile raf = new RandomAccessFile(file.toFile(), "r");){
            int bytesRead;
            byte[] buffer = new byte[8128];
            while ((bytesRead = raf.read(buffer)) != -1) {
                for (int i = 0; i < bytesRead; ++i) {
                    b = (char)buffer[i];
                    if (b == '\t' || b == '\n' || b == '\r' || b == ' ') continue;
                    if (b > '\u00ff') {
                        while (b > '\u00ff') {
                            b = (char)(b - 255);
                        }
                    }
                    k |= (long)b << shift;
                    if ((shift += 8) != 32) continue;
                    h2 = 0xFFFFFFFFL & h2;
                    k *= 1540483477L;
                    k = 0xFFFFFFFFL & k;
                    k ^= k >> 24;
                    k = 0xFFFFFFFFL & k;
                    k *= 1540483477L;
                    k = 0xFFFFFFFFL & k;
                    h2 *= 1540483477L;
                    h2 = 0xFFFFFFFFL & h2;
                    h2 ^= k;
                    h2 = 0xFFFFFFFFL & h2;
                    k = 0L;
                    shift = 0;
                }
            }
        }
        if (shift > 0) {
            h2 ^= k;
            h2 = 0xFFFFFFFFL & h2;
            h2 *= 1540483477L;
            h2 = 0xFFFFFFFFL & h2;
        }
        h2 ^= h2 >> 13;
        h2 = 0xFFFFFFFFL & h2;
        h2 *= 1540483477L;
        h2 = 0xFFFFFFFFL & h2;
        h2 ^= h2 >> 15;
        h2 = 0xFFFFFFFFL & h2;
        return String.valueOf(h2);
    }

    public static boolean hashCompare(Path file1, Path file2) {
        if (!Files.exists(file1, new LinkOption[0]) || !Files.exists(file2, new LinkOption[0])) {
            return false;
        }
        String hash1 = CustomFileUtils.getHash(file1);
        String hash2 = CustomFileUtils.getHash(file2);
        if (hash1 == null || hash2 == null) {
            return false;
        }
        return hash1.equals(hash2);
    }

    public static boolean isEmptyDirectory(Path parentPath) throws IOException {
        if (!Files.isDirectory(parentPath, new LinkOption[0])) {
            return false;
        }
        try (Stream<Path> pathStream = Files.list(parentPath);){
            boolean bl = pathStream.findAny().isEmpty();
            return bl;
        }
    }
}

