/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.cms;

import amp_libs.org.bouncycastle.asn1.ASN1Encodable;
import amp_libs.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import amp_libs.org.bouncycastle.asn1.ASN1Sequence;
import amp_libs.org.bouncycastle.cms.CMSException;
import amp_libs.org.bouncycastle.cms.CMSTypedData;
import java.io.IOException;
import java.io.OutputStream;

public class PKCS7ProcessableObject
implements CMSTypedData {
    private final ASN1ObjectIdentifier type;
    private final ASN1Encodable structure;

    public PKCS7ProcessableObject(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.type = aSN1ObjectIdentifier;
        this.structure = aSN1Encodable;
    }

    @Override
    public ASN1ObjectIdentifier getContentType() {
        return this.type;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException, CMSException {
        if (this.structure instanceof ASN1Sequence) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(this.structure);
            for (ASN1Encodable aSN1Encodable : aSN1Sequence) {
                outputStream.write(aSN1Encodable.toASN1Primitive().getEncoded("DER"));
            }
        } else {
            byte[] byArray = this.structure.toASN1Primitive().getEncoded("DER");
            int n = 1;
            while ((byArray[n] & 0xFF) > 127) {
                ++n;
            }
            outputStream.write(byArray, ++n, byArray.length - n);
        }
    }

    @Override
    public Object getContent() {
        return this.structure;
    }
}

