/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.crypto.generators;

import am_libs.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import am_libs.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import am_libs.org.bouncycastle.crypto.CryptoServicePurpose;
import am_libs.org.bouncycastle.crypto.CryptoServicesRegistrar;
import am_libs.org.bouncycastle.crypto.KeyGenerationParameters;
import am_libs.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import am_libs.org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import am_libs.org.bouncycastle.crypto.params.X448PublicKeyParameters;
import java.security.SecureRandom;

public class X448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("X448KeyGen", 224, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        X448PrivateKeyParameters x448PrivateKeyParameters = new X448PrivateKeyParameters(this.random);
        X448PublicKeyParameters x448PublicKeyParameters = x448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(x448PublicKeyParameters, x448PrivateKeyParameters);
    }
}

