/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import amp_libs.org.tomlj.Toml;
import amp_libs.org.tomlj.TomlArray;
import amp_libs.org.tomlj.TomlParseResult;
import amp_libs.org.tomlj.TomlTable;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.loader.LoaderManagerService;
import pl.skidam.automodpack_core.utils.CustomFileUtils;

public class FileInspection {
    private static final Map<HashPathPair, Mod> modCache = new HashMap<HashPathPair, Mod>();
    private static final Set<String> services = Set.of("META-INF/services/net.minecraftforge.forgespi.locating.IModLocator", "META-INF/services/net.minecraftforge.forgespi.locating.IDependencyLocator", "META-INF/services/net.minecraftforge.forgespi.language.IModLanguageProvider", "META-INF/services/net.neoforged.neoforgespi.locating.IModLocator", "META-INF/services/net.neoforged.neoforgespi.locating.IDependencyLocator", "META-INF/services/net.neoforged.neoforgespi.locating.IModLanguageLoader", "META-INF/services/net.neoforged.neoforgespi.locating.IModFileCandidateLocator", "META-INF/services/net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper");
    private static final String forbiddenChars = "\\/:*\"<>|!?&%$;=+";

    public static boolean isMod(Path file) {
        return FileInspection.getModID(file) != null || FileInspection.hasSpecificServices(file);
    }

    public static Mod getMod(Path file) {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return null;
        }
        if (!file.getFileName().toString().endsWith(".jar")) {
            return null;
        }
        String hash = CustomFileUtils.getHash(file);
        if (hash == null) {
            GlobalVariables.LOGGER.error("Failed to get hash for file: {}", (Object)file);
            return null;
        }
        HashPathPair hashPathPair = new HashPathPair(hash, file);
        if (modCache.containsKey(hashPathPair)) {
            return modCache.get(hashPathPair);
        }
        for (Mod mod : GlobalVariables.LOADER_MANAGER.getModList()) {
            if (!hash.equals(mod.hash)) continue;
            modCache.put(hashPathPair, mod);
            return mod;
        }
        String modId = FileInspection.getModID(file);
        if (modId != null) {
            String modVersion = FileInspection.getModVersion(file);
            LoaderManagerService.EnvironmentType environmentType = FileInspection.getModEnvironment(file);
            Set<String> dependencies = FileInspection.getModDependencies(file);
            Set<String> providesIDs = FileInspection.getAllProvidedIDs(file);
            if (modVersion != null && dependencies != null) {
                Mod mod = new Mod(modId, hash, providesIDs, modVersion, file, environmentType, dependencies);
                modCache.put(hashPathPair, mod);
                return mod;
            }
            GlobalVariables.LOGGER.error("Not enough mod information for file: {} modId: {}, modVersion: {}, dependencies: {}", (Object)file, (Object)modId, (Object)modVersion, dependencies);
        }
        GlobalVariables.LOGGER.debug("Failed to get mod info for file: {}", (Object)file);
        return null;
    }

    public static Path getThizJar() {
        try {
            URI uri = FileInspection.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            String path = uri.getPath();
            int index = path.indexOf(33);
            if (index != -1) {
                path = path.substring(0, index);
            }
            if ((index = path.indexOf(35)) != -1) {
                path = path.substring(0, index);
            }
            if (System.getProperty("os.name").toLowerCase().contains("win") && path.startsWith("/")) {
                path = path.substring(1);
            }
            return Path.of(path, new String[0]).toAbsolutePath().normalize();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasSpecificServices(Path file) {
        if (!file.getFileName().toString().endsWith(".jar")) return false;
        if (!Files.exists(file, new LinkOption[0])) {
            return false;
        }
        try (ZipFile zipFile = new ZipFile(file.toFile());){
            for (String service : services) {
                ZipEntry entry = zipFile.getEntry(service);
                if (entry == null) continue;
                boolean bl = true;
                return bl;
            }
            String jarjarPrefix = "META-INF/jarjar/";
            ZipEntry jarjarEntry = zipFile.getEntry(jarjarPrefix);
            if (jarjarEntry == null) {
                boolean bl = false;
                return bl;
            }
            Iterator<? extends ZipEntry> iterator = Collections.list(zipFile.entries()).iterator();
            while (iterator.hasNext()) {
                ZipInputStream zipInputStream;
                block29: {
                    ZipEntry zipEntry = iterator.next();
                    String entryName = zipEntry.getName();
                    if (zipEntry.isDirectory() || !entryName.startsWith(jarjarPrefix) || !entryName.endsWith(".jar")) continue;
                    try {
                        boolean bl;
                        InputStream inputStream;
                        block28: {
                            inputStream = zipFile.getInputStream(zipEntry);
                            zipInputStream = new ZipInputStream(inputStream);
                            try {
                                ZipEntry nestedEntry;
                                while ((nestedEntry = zipInputStream.getNextEntry()) != null) {
                                    if (!services.contains(nestedEntry.getName())) continue;
                                    bl = true;
                                    break block28;
                                }
                                break block29;
                            }
                            catch (Throwable throwable) {
                                try {
                                    zipInputStream.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        zipInputStream.close();
                        if (inputStream == null) return bl;
                        inputStream.close();
                        return bl;
                    }
                    catch (IOException e) {
                        GlobalVariables.LOGGER.error("Error reading nested JAR in {}: {}", (Object)file, (Object)e.getMessage());
                    }
                }
                zipInputStream.close();
            }
            return false;
        }
        catch (IOException e) {
            GlobalVariables.LOGGER.error("Error examining JAR file {}: {}", (Object)file, (Object)e.getMessage());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isModCompatible(Path file) {
        if (!file.getFileName().toString().endsWith(".jar")) return false;
        if (!Files.exists(file, new LinkOption[0])) {
            return false;
        }
        try (ZipFile zipFile = new ZipFile(file.toFile());){
            String entryName;
            String loader;
            switch (loader = GlobalVariables.LOADER) {
                case "fabric": {
                    String string = "fabric.mod.json";
                    break;
                }
                case "quilt": {
                    String string = "quilt.mod.json";
                    break;
                }
                case "forge": {
                    String string = "META-INF/mods.toml";
                    break;
                }
                case "neoforge": {
                    String string = "META-INF/neoforge.mods.toml";
                    break;
                }
                default: {
                    String string = entryName = null;
                }
            }
            if ((loader.equals("forge") || loader.equals("neoforge")) && FileInspection.hasSpecificServices(file)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = entryName != null && zipFile.getEntry(entryName) != null;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static ZipEntry getMetadataEntry(ZipFile zipFile) {
        String[] entriesToCheck;
        ZipEntry entry;
        String currentLoader;
        switch (currentLoader = GlobalVariables.LOADER) {
            case "fabric": {
                ZipEntry zipEntry = zipFile.getEntry("fabric.mod.json");
                break;
            }
            case "quilt": {
                ZipEntry zipEntry = zipFile.getEntry("quilt.mod.json");
                break;
            }
            case "forge": {
                ZipEntry zipEntry = zipFile.getEntry("META-INF/mods.toml");
                break;
            }
            case "neoforge": {
                ZipEntry zipEntry = zipFile.getEntry("META-INF/neoforge.mods.toml");
                break;
            }
            default: {
                ZipEntry zipEntry = entry = null;
            }
        }
        if (entry != null) {
            return entry;
        }
        for (String entryName : entriesToCheck = new String[]{"fabric.mod.json", "META-INF/neoforge.mods.toml", "META-INF/mods.toml", "quilt.mod.json"}) {
            entry = zipFile.getEntry(entryName);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    public static String getModVersion(Path file) {
        return (String)FileInspection.getModInfo(file, "version");
    }

    public static String getModID(Path file) {
        return (String)FileInspection.getModInfo(file, "modId");
    }

    public static Set<String> getAllProvidedIDs(Path file) {
        return (Set)FileInspection.getModInfo(file, "provides");
    }

    public static Set<String> getModDependencies(Path file) {
        return (Set)FileInspection.getModInfo(file, "dependencies");
    }

    public static LoaderManagerService.EnvironmentType getModEnvironment(Path file) {
        return (LoaderManagerService.EnvironmentType)((Object)FileInspection.getModInfo(file, "environment"));
    }

    /*
     * Exception decompiling
     */
    private static Object getModInfo(Path file, String infoType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Object getModInfoFromToml(BufferedReader reader, String infoType, Path file) {
        try {
            TomlParseResult result = Toml.parse(reader);
            result.errors().forEach(error -> GlobalVariables.LOGGER.error(error.toString()));
            TomlArray modsArray = result.getArray("mods");
            if (modsArray == null) {
                return infoType.equals("version") || infoType.equals("modId") || infoType.equals("environment") ? null : Set.of();
            }
            switch (infoType) {
                case "version": {
                    String modVersion = null;
                    for (Object o : modsArray.toList()) {
                        TomlTable mod = (TomlTable)o;
                        if (mod == null) continue;
                        modVersion = mod.getString("version");
                    }
                    return modVersion != null ? modVersion : "1";
                }
                case "modId": {
                    String modID = null;
                    for (Object o : modsArray.toList()) {
                        TomlTable mod = (TomlTable)o;
                        if (mod == null) continue;
                        modID = mod.getString("modId");
                    }
                    return modID;
                }
                case "provides": {
                    HashSet<String> providedIDs = new HashSet<String>();
                    for (Object o : modsArray.toList()) {
                        TomlArray providesArray;
                        TomlTable mod = (TomlTable)o;
                        if (mod == null || (providesArray = mod.getArray("provides")) == null) continue;
                        for (int j = 0; j < providesArray.size(); ++j) {
                            String id = providesArray.getString(j);
                            if (id == null || id.isEmpty()) continue;
                            providedIDs.add(id);
                        }
                    }
                    return providedIDs;
                }
                case "dependencies": {
                    String modID = FileInspection.getModID(file);
                    TomlArray dependenciesArray = result.getArray("dependencies.\"" + modID + "\"");
                    HashSet<String> dependencies = new HashSet<String>();
                    if (dependenciesArray == null) {
                        return dependencies;
                    }
                    for (Object o : dependenciesArray.toList()) {
                        String depId;
                        TomlTable mod = (TomlTable)o;
                        if (mod == null || (depId = mod.getString("modId")) == null) continue;
                        dependencies.add(depId);
                    }
                    return dependencies;
                }
                case "environment": {
                    LoaderManagerService.EnvironmentType environment = LoaderManagerService.EnvironmentType.UNIVERSAL;
                    String modID = FileInspection.getModID(file);
                    TomlArray dependenciesArray = result.getArray("dependencies.\"" + modID + "\"");
                    if (dependenciesArray == null) {
                        return environment;
                    }
                    for (Object o : dependenciesArray.toList()) {
                        String depEnv;
                        String depId;
                        TomlTable mod = (TomlTable)o;
                        if (mod == null || (depId = mod.getString("modId")) == null || !depId.equals("minecraft") && !depId.equals("neoforge") && !depId.equals("forge") || (depEnv = mod.getString("side")) == null) continue;
                        switch (depEnv.toLowerCase()) {
                            case "client": {
                                environment = LoaderManagerService.EnvironmentType.CLIENT;
                                break;
                            }
                            case "server": {
                                environment = LoaderManagerService.EnvironmentType.SERVER;
                            }
                        }
                        if (environment == LoaderManagerService.EnvironmentType.UNIVERSAL) continue;
                        return environment;
                    }
                    return environment;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return infoType.equals("version") || infoType.equals("modId") || infoType.equals("environment") ? null : Set.of();
    }

    private static Object getModInfoFromJson(BufferedReader reader, Gson gson, String infoType) {
        JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
        switch (infoType) {
            case "version": {
                if (json.has("version")) {
                    return json.get("version").getAsString();
                }
                if (!json.has("quilt_loader") || !json.get("quilt_loader").getAsJsonObject().has("version")) break;
                return json.get("quilt_loader").getAsJsonObject().get("version").getAsString();
            }
            case "modId": {
                if (json.has("id")) {
                    return json.get("id").getAsString();
                }
                if (!json.has("quilt_loader") || !json.get("quilt_loader").getAsJsonObject().has("id")) break;
                return json.get("quilt_loader").getAsJsonObject().get("id").getAsString();
            }
            case "provides": {
                HashSet<String> providedIDs = new HashSet<String>();
                if (json.has("provides")) {
                    for (JsonElement provides : json.get("provides").getAsJsonArray()) {
                        providedIDs.add(provides.getAsString());
                    }
                } else if (json.has("quilt_loader") && json.get("quilt_loader").getAsJsonObject().has("provides")) {
                    JsonObject quiltLoader = json.get("quilt_loader").getAsJsonObject();
                    for (JsonElement provides : quiltLoader.get("provides").getAsJsonArray()) {
                        JsonObject providesObject = provides.getAsJsonObject();
                        String id = providesObject.get("id").getAsString();
                        providedIDs.add(id);
                    }
                }
                return providedIDs;
            }
            case "dependencies": {
                JsonObject depends;
                HashSet<String> dependencies = new HashSet<String>();
                if (json.has("depends")) {
                    JsonObject depends2 = json.get("depends").getAsJsonObject();
                    if (depends2 != null) {
                        dependencies.addAll(depends2.entrySet().stream().map(Map.Entry::getKey).toList());
                    }
                } else if (json.has("quilt_loader") && json.get("quilt_loader").getAsJsonObject().has("depends") && (depends = json.get("quilt_loader").getAsJsonObject().get("depends").getAsJsonObject()) != null) {
                    dependencies.addAll(depends.entrySet().stream().map(Map.Entry::getKey).toList());
                }
                return dependencies;
            }
            case "environment": {
                if (json.has("environment")) {
                    String environment = json.get("environment").getAsString();
                    if (environment == null) {
                        return LoaderManagerService.EnvironmentType.UNIVERSAL;
                    }
                    return switch (environment.toLowerCase()) {
                        case "client" -> LoaderManagerService.EnvironmentType.CLIENT;
                        case "server" -> LoaderManagerService.EnvironmentType.SERVER;
                        default -> LoaderManagerService.EnvironmentType.UNIVERSAL;
                    };
                }
                if (!json.has("quilt_loader") || !json.get("minecraft").getAsJsonObject().has("environment")) break;
                String environment = json.get("minecraft").getAsJsonObject().get("environment").getAsString();
                if (environment == null) {
                    return LoaderManagerService.EnvironmentType.UNIVERSAL;
                }
                return switch (environment.toLowerCase()) {
                    case "client" -> LoaderManagerService.EnvironmentType.CLIENT;
                    case "server" -> LoaderManagerService.EnvironmentType.SERVER;
                    default -> LoaderManagerService.EnvironmentType.UNIVERSAL;
                };
            }
        }
        return infoType.equals("version") || infoType.equals("modId") || infoType.equals("environment") ? null : Set.of();
    }

    public static boolean isInValidFileName(String fileName) {
        for (char c : forbiddenChars.toCharArray()) {
            if (fileName.indexOf(c) == -1) continue;
            return true;
        }
        for (char c : fileName.toCharArray()) {
            if (c >= ' ' && c != '\u007f') continue;
            return true;
        }
        return fileName.trim().isEmpty();
    }

    public static String fixFileName(String fileName) {
        for (char c : fileName.toCharArray()) {
            if (c < ' ' || c == '\u007f') {
                fileName = fileName.replace(c, '-');
            }
            if (forbiddenChars.indexOf(c) == -1) continue;
            fileName = fileName.replace(c, '-');
        }
        fileName = fileName.trim();
        return fileName;
    }

    public record HashPathPair(String hash, Path path) {
    }

    public record Mod(String modID, String hash, Collection<String> providesIDs, String modVersion, Path modPath, LoaderManagerService.EnvironmentType environmentType, Collection<String> dependencies) {
    }
}

