/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core.loader;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.loader.LoaderManagerService;
import pl.skidam.automodpack_core.utils.CustomFileUtils;
import pl.skidam.automodpack_core.utils.FileInspection;

public class LoaderManager
implements LoaderManagerService {
    private Collection<FileInspection.Mod> modList = new ArrayList<FileInspection.Mod>();
    private int lastLoadingModListSize = -1;

    @Override
    public LoaderManagerService.ModPlatform getPlatformType() {
        return LoaderManagerService.ModPlatform.FABRIC;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public Collection<FileInspection.Mod> getModList() {
        Collection mods = FabricLoader.getInstance().getAllMods();
        if (!this.modList.isEmpty() && this.lastLoadingModListSize == mods.size()) {
            return this.modList;
        }
        this.lastLoadingModListSize = mods.size();
        ArrayList<FileInspection.Mod> modList = new ArrayList<FileInspection.Mod>();
        for (ModContainer info : mods) {
            try {
                String hash;
                String modID = info.getMetadata().getId();
                Path path = this.getModPath(modID);
                if (path == null || path.toString().isEmpty() || (hash = CustomFileUtils.getHash(path)) == null) continue;
                HashSet<String> providesIDs = new HashSet<String>(info.getMetadata().getProvides());
                List<String> dependencies = info.getMetadata().getDependencies().stream().filter(d -> d.getKind().equals((Object)ModDependency.Kind.DEPENDS)).map(ModDependency::getModId).toList();
                FileInspection.Mod mod = new FileInspection.Mod(modID, hash, providesIDs, info.getMetadata().getVersion().getFriendlyString(), path, this.getModEnvironment(modID), dependencies);
                modList.add(mod);
            }
            catch (Exception exception) {}
        }
        this.modList = modList;
        return this.modList;
    }

    @Override
    public String getLoaderVersion() {
        Optional modContainer = FabricLoader.getInstance().getModContainer("fabricloader");
        return modContainer.map(container -> container.getMetadata().getVersion().getFriendlyString()).orElse(null);
    }

    private Path getModPath(String modId) {
        if (!this.isModLoaded(modId)) {
            return null;
        }
        try {
            for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
                if (!modContainer.getMetadata().getId().equals(modId)) continue;
                FileSystem fileSys = ((Path)modContainer.getRootPaths().get(0)).getFileSystem();
                return Path.of(fileSys.toString(), new String[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GlobalVariables.LOGGER.error("Could not find jar file for {}", (Object)modId);
        return null;
    }

    @Override
    public LoaderManagerService.EnvironmentType getEnvironmentType() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return LoaderManagerService.EnvironmentType.CLIENT;
        }
        return LoaderManagerService.EnvironmentType.SERVER;
    }

    @Override
    public String getModVersion(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).isPresent() ? ((ModContainer)FabricLoader.getInstance().getModContainer(modId).get()).getMetadata().getVersion().getFriendlyString() : null;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    private LoaderManagerService.EnvironmentType getModEnvironment(String modId) {
        Optional container = FabricLoader.getInstance().getModContainer(modId);
        if (container.isEmpty()) {
            return LoaderManagerService.EnvironmentType.UNIVERSAL;
        }
        ModEnvironment env = ((ModContainer)container.get()).getMetadata().getEnvironment();
        if (env == ModEnvironment.CLIENT) {
            return LoaderManagerService.EnvironmentType.CLIENT;
        }
        if (env == ModEnvironment.SERVER) {
            return LoaderManagerService.EnvironmentType.SERVER;
        }
        return LoaderManagerService.EnvironmentType.UNIVERSAL;
    }
}

