/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core;

import com.google.common.collect.Maps;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.ImmediateWindowHandler;
import net.minecraftforge.fml.loading.UniqueModListBuilder;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileModLocator;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModFileException;
import net.minecraftforge.fml.loading.moddiscovery.ModDiscoverer;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IDependencyLocator;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.forgespi.locating.ModFileLoadingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.skidam.automodpack_loader_core.LazyModLocator;
import pl.skidam.automodpack_loader_core.Preload;
import pl.skidam.automodpack_loader_core.mods.ModpackLoader;

public class EarlyModLocator
extends AbstractJarFileModLocator {
    private final Logger LOGGER = LogManager.getLogger((String)"AutoModpack/BootStrap");
    private Map<String, ?> arguments;
    public List<IModLocator.ModFileOrException> candidates = new ArrayList<IModLocator.ModFileOrException>();

    public void initArguments(Map<String, ?> arguments) {
        this.arguments = arguments;
    }

    public String name() {
        return "automodpack_bootstrap";
    }

    public Stream<Path> scanCandidates() {
        new Preload();
        try {
            Method method = FMLLoader.class.getDeclaredMethod("getModDiscoverer", new Class[0]);
            method.setAccessible(true);
            ModDiscoverer discoverer = (ModDiscoverer)method.invoke(null, new Object[0]);
            Field dependencyLocList = ModDiscoverer.class.getDeclaredField("dependencyLocatorList");
            dependencyLocList.setAccessible(true);
            List originalDependencyLocatorList = (List)dependencyLocList.get(discoverer);
            originalDependencyLocatorList.sort(Comparator.comparingInt(loc -> loc instanceof LazyModLocator ? 1 : 0));
        }
        catch (Exception e) {
            this.LOGGER.error("Error sorting FML dependency locators", (Throwable)e);
        }
        return ModpackLoader.modsToLoad.stream();
    }

    private boolean loadNewModLocators() throws MalformedURLException {
        IModuleLayerManager moduleLayerManager = (IModuleLayerManager)Launcher.INSTANCE.environment().findModuleLayerManager().orElseThrow();
        ServiceLoader<IModLocator> modLocators = ServiceLoader.load((ModuleLayer)moduleLayerManager.getLayer(IModuleLayerManager.Layer.SERVICE).orElseThrow(), IModLocator.class);
        ServiceLoader<IDependencyLocator> dependencyLocators = ServiceLoader.load((ModuleLayer)moduleLayerManager.getLayer(IModuleLayerManager.Layer.SERVICE).orElseThrow(), IDependencyLocator.class);
        HashMap<String, IModLocator> newModLocators = new HashMap<String, IModLocator>();
        HashMap<String, IDependencyLocator> newDependencyLocators = new HashMap<String, IDependencyLocator>();
        for (Path jarPath : ModpackLoader.modsToLoad) {
            URL newJarUrl = jarPath.toUri().toURL();
            URLClassLoader newClassLoader = new URLClassLoader(new URL[]{newJarUrl}, LazyModLocator.class.getClassLoader());
            ServiceLoader<IModLocator> IModLocatorProviders = ServiceLoader.load(IModLocator.class, newClassLoader);
            ServiceLoader<IDependencyLocator> IDependencyLocatorProviders = ServiceLoader.load(IDependencyLocator.class, newClassLoader);
            for (IModLocator modLocator2 : IModLocatorProviders) {
                newModLocators.put(modLocator2.getClass().getName(), modLocator2);
            }
            for (IDependencyLocator dependencyLocator2 : IDependencyLocatorProviders) {
                newDependencyLocators.put(dependencyLocator2.getClass().getName(), dependencyLocator2);
            }
        }
        for (IModLocator modLocator3 : modLocators) {
            newModLocators.remove(modLocator3.getClass().getName());
        }
        for (IDependencyLocator dependencyLocator3 : dependencyLocators) {
            newDependencyLocators.remove(dependencyLocator3.getClass().getName());
        }
        if (newModLocators.isEmpty() && newDependencyLocators.isEmpty()) {
            return false;
        }
        this.LOGGER.error("Done loading new locators");
        this.LOGGER.warn("New mod locators: ");
        newModLocators.forEach((name, clazz) -> this.LOGGER.info(name));
        this.LOGGER.warn("New dependency locators: ");
        newDependencyLocators.forEach((name, clazz) -> this.LOGGER.info(name));
        newModLocators.forEach((name, modLocator) -> modLocator.initArguments(this.arguments));
        newDependencyLocators.forEach((name, dependencyLocator) -> dependencyLocator.initArguments(this.arguments));
        return this.discoverMods(newModLocators.values());
    }

    private boolean discoverMods(Collection<IModLocator> modLocators) {
        this.LOGGER.info("Scanning for mods and other resources to load. We know {} ways to find mods", (Object)modLocators.size());
        ArrayList<ModFile> loadedFiles = new ArrayList();
        ArrayList discoveryErrorData = new ArrayList();
        boolean successfullyLoadedMods = true;
        ArrayList<IModFileInfo> brokenFiles = new ArrayList<IModFileInfo>();
        ImmediateWindowHandler.updateProgress((String)"Discovering mod files");
        for (IModLocator locator : modLocators) {
            try {
                List<IModFile> locatedFiles;
                List<IModFile> badModFiles;
                this.LOGGER.info("Trying locator {}", (Object)locator);
                Thread contextThread = new Thread(() -> {
                    try {
                        this.candidates = locator.scanMods();
                    }
                    catch (Exception e) {
                        this.LOGGER.error("Error running locator {}", (Object)locator, (Object)e);
                    }
                });
                contextThread.setContextClassLoader(locator.getClass().getClassLoader());
                contextThread.start();
                contextThread.join();
                this.LOGGER.info("Locator {} found {} candidates or errors", (Object)locator, (Object)this.candidates.size());
                List<ModFileLoadingException> exceptions = this.candidates.stream().map(IModLocator.ModFileOrException::ex).filter(Objects::nonNull).toList();
                if (!exceptions.isEmpty()) {
                    this.LOGGER.info("Locator {} found {} invalid mod files", (Object)locator, (Object)exceptions.size());
                    brokenFiles.addAll(exceptions.stream().map(e -> {
                        IModFileInfo iModFileInfo;
                        if (e instanceof InvalidModFileException) {
                            InvalidModFileException ime = (InvalidModFileException)((Object)e);
                            iModFileInfo = ime.getBrokenFile();
                        } else {
                            iModFileInfo = null;
                        }
                        return iModFileInfo;
                    }).filter(Objects::nonNull).toList());
                }
                if (!(badModFiles = (locatedFiles = this.candidates.stream().map(IModLocator.ModFileOrException::file).filter(Objects::nonNull).collect(Collectors.toList())).stream().filter(file -> !(file instanceof ModFile)).toList()).isEmpty()) {
                    this.LOGGER.info("Locator {} returned {} files which is are not ModFile instances! They will be skipped!", (Object)locator, (Object)badModFiles.size());
                    brokenFiles.addAll(badModFiles.stream().map(IModFile::getModFileInfo).toList());
                }
                locatedFiles.removeAll(badModFiles);
                this.LOGGER.info("Locator {} found {} valid mod files", (Object)locator, (Object)locatedFiles.size());
                this.handleLocatedFiles(loadedFiles, locatedFiles);
            }
            catch (InvalidModFileException imfe) {
                this.LOGGER.error("Locator {} found an invalid mod file {}", (Object)locator, (Object)imfe.getBrokenFile(), (Object)imfe);
                brokenFiles.add(imfe.getBrokenFile());
            }
            catch (EarlyLoadingException exception) {
                this.LOGGER.error("Failed to load mods with locator {}", (Object)locator, (Object)exception);
                discoveryErrorData.addAll(exception.getAllData());
            }
            catch (InterruptedException e2) {
                throw new RuntimeException(e2);
            }
        }
        Map<Object, Object> modFilesMap = Maps.newHashMap();
        try {
            UniqueModListBuilder modsUniqueListBuilder = new UniqueModListBuilder(loadedFiles);
            UniqueModListBuilder.UniqueModListData uniqueModsData = modsUniqueListBuilder.buildUniqueList();
            modFilesMap = uniqueModsData.modFiles().stream().collect(Collectors.groupingBy(IModFile::getType));
            loadedFiles = uniqueModsData.modFiles();
        }
        catch (EarlyLoadingException exception) {
            this.LOGGER.error("Failed to build unique mod list after mod discovery.", (Throwable)exception);
            discoveryErrorData.addAll(exception.getAllData());
            successfullyLoadedMods = false;
        }
        return successfullyLoadedMods;
    }

    private void handleLocatedFiles(List<ModFile> loadedFiles, List<IModFile> locatedFiles) {
        List<ModFile> locatedModFiles = locatedFiles.stream().filter(ModFile.class::isInstance).map(ModFile.class::cast).toList();
        for (IModFile iModFile : locatedModFiles) {
            this.LOGGER.info("Found mod file {} of type {} with provider {}", (Object)iModFile.getFileName(), (Object)iModFile.getType(), (Object)iModFile.getProvider());
        }
        loadedFiles.addAll(locatedModFiles);
    }
}

