/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.cms;

import amp_libs.org.bouncycastle.asn1.ASN1Integer;
import amp_libs.org.bouncycastle.asn1.DEROctetString;
import amp_libs.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import amp_libs.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import amp_libs.org.bouncycastle.asn1.cms.KEMRecipientInfo;
import amp_libs.org.bouncycastle.asn1.cms.OtherRecipientInfo;
import amp_libs.org.bouncycastle.asn1.cms.RecipientIdentifier;
import amp_libs.org.bouncycastle.asn1.cms.RecipientInfo;
import amp_libs.org.bouncycastle.cms.CMSException;
import amp_libs.org.bouncycastle.cms.KEMKeyWrapper;
import amp_libs.org.bouncycastle.cms.RecipientInfoGenerator;
import amp_libs.org.bouncycastle.operator.GenericKey;
import amp_libs.org.bouncycastle.operator.OperatorException;

public abstract class KEMRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected final KEMKeyWrapper wrapper;
    private IssuerAndSerialNumber issuerAndSerial;
    private byte[] subjectKeyIdentifier;

    protected KEMRecipientInfoGenerator(IssuerAndSerialNumber issuerAndSerialNumber, KEMKeyWrapper kEMKeyWrapper) {
        this.issuerAndSerial = issuerAndSerialNumber;
        this.wrapper = kEMKeyWrapper;
    }

    protected KEMRecipientInfoGenerator(byte[] byArray, KEMKeyWrapper kEMKeyWrapper) {
        this.subjectKeyIdentifier = byArray;
        this.wrapper = kEMKeyWrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        byte[] byArray;
        try {
            byArray = this.wrapper.generateWrappedKey(genericKey);
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
        RecipientIdentifier recipientIdentifier = this.issuerAndSerial != null ? new RecipientIdentifier(this.issuerAndSerial) : new RecipientIdentifier(new DEROctetString(this.subjectKeyIdentifier));
        return new RecipientInfo(new OtherRecipientInfo(CMSObjectIdentifiers.id_ori_kem, new KEMRecipientInfo(recipientIdentifier, this.wrapper.getAlgorithmIdentifier(), new DEROctetString(this.wrapper.getEncapsulation()), this.wrapper.getKdfAlgorithmIdentifier(), new ASN1Integer(this.wrapper.getKekLength()), null, this.wrapper.getWrapAlgorithmIdentifier(), new DEROctetString(byArray))));
    }
}

