/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.pqc.crypto.hqc;

import amp_libs.org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import amp_libs.org.bouncycastle.pqc.crypto.hqc.HQCEngine;
import amp_libs.org.bouncycastle.pqc.crypto.hqc.HQCKeyParameters;
import amp_libs.org.bouncycastle.pqc.crypto.hqc.HQCParameters;
import amp_libs.org.bouncycastle.pqc.crypto.hqc.HQCPrivateKeyParameters;
import amp_libs.org.bouncycastle.util.Arrays;

public class HQCKEMExtractor
implements EncapsulatedSecretExtractor {
    private HQCEngine engine;
    private final HQCKeyParameters key;

    public HQCKEMExtractor(HQCPrivateKeyParameters hQCPrivateKeyParameters) {
        this.key = hQCPrivateKeyParameters;
        this.initCipher(this.key.getParameters());
    }

    private void initCipher(HQCParameters hQCParameters) {
        this.engine = hQCParameters.getEngine();
    }

    @Override
    public byte[] extractSecret(byte[] byArray) {
        byte[] byArray2 = new byte[64];
        HQCPrivateKeyParameters hQCPrivateKeyParameters = (HQCPrivateKeyParameters)this.key;
        byte[] byArray3 = hQCPrivateKeyParameters.getPrivateKey();
        this.engine.decaps(byArray2, byArray, byArray3);
        return Arrays.copyOfRange(byArray2, 0, 32);
    }

    @Override
    public int getEncapsulationLength() {
        return this.key.getParameters().getN_BYTES() + this.key.getParameters().getN1N2_BYTES() + 16;
    }
}

