/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.auth.Secrets;
import pl.skidam.automodpack_core.auth.SecretsStore;
import pl.skidam.automodpack_core.config.ConfigTools;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.loader.LoaderManagerService;
import pl.skidam.automodpack_core.utils.AddressHelpers;
import pl.skidam.automodpack_core.utils.CustomFileUtils;
import pl.skidam.automodpack_core.utils.FileInspection;
import pl.skidam.automodpack_core.utils.ManifestReader;
import pl.skidam.automodpack_core.utils.ModpackContentTools;
import pl.skidam.automodpack_loader_core.SelfUpdater;
import pl.skidam.automodpack_loader_core.client.ModpackUpdater;
import pl.skidam.automodpack_loader_core.client.ModpackUtils;
import pl.skidam.automodpack_loader_core.loader.LoaderManager;
import pl.skidam.automodpack_loader_core.mods.ModpackLoader;

public class Preload {
    public Preload() {
        try {
            long start = System.currentTimeMillis();
            GlobalVariables.LOGGER.info("Prelaunching AutoModpack...");
            this.initializeGlobalVariables();
            this.loadConfigs();
            this.updateAll();
            GlobalVariables.LOGGER.info("AutoModpack prelaunched! took " + (System.currentTimeMillis() - start) + "ms");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void updateAll() {
        Optional<Path> optionalSelectedModpackDir = ModpackContentTools.getModpackDir(GlobalVariables.clientConfig.selectedModpack);
        if (GlobalVariables.LOADER_MANAGER.getEnvironmentType() == LoaderManagerService.EnvironmentType.SERVER || optionalSelectedModpackDir.isEmpty()) {
            SelfUpdater.update();
            return;
        }
        GlobalVariables.selectedModpackDir = optionalSelectedModpackDir.get();
        String selectedModpackLink = "";
        if (!GlobalVariables.clientConfig.selectedModpack.isBlank() && GlobalVariables.clientConfig.installedModpacks.containsKey(GlobalVariables.clientConfig.selectedModpack)) {
            selectedModpackLink = GlobalVariables.clientConfig.installedModpacks.get(GlobalVariables.clientConfig.selectedModpack);
        }
        if (selectedModpackLink == null || selectedModpackLink.isBlank()) {
            SelfUpdater.update();
            return;
        }
        if (selectedModpackLink.startsWith("http") && selectedModpackLink.contains("/automodpack")) {
            String newSelectedModpackLink = selectedModpackLink;
            newSelectedModpackLink = newSelectedModpackLink.replace("http://", "");
            newSelectedModpackLink = newSelectedModpackLink.replace("https://", "");
            String[] split = newSelectedModpackLink.split("/automodpack");
            if ((newSelectedModpackLink = split[0]) != null && !newSelectedModpackLink.isBlank()) {
                GlobalVariables.LOGGER.info("Updated modpack link to new format: {} -> {}", (Object)selectedModpackLink, (Object)newSelectedModpackLink);
                GlobalVariables.clientConfig.installedModpacks.put(GlobalVariables.clientConfig.selectedModpack, newSelectedModpackLink);
                ConfigTools.save(GlobalVariables.clientConfigFile, GlobalVariables.clientConfig);
                selectedModpackLink = newSelectedModpackLink;
            }
        }
        InetSocketAddress selectedModpackAddress = AddressHelpers.parse(selectedModpackLink);
        Secrets.Secret secret = SecretsStore.getClientSecret(GlobalVariables.clientConfig.selectedModpack);
        Optional<Jsons.ModpackContentFields> optionalLatestModpackContent = ModpackUtils.requestServerModpackContent(selectedModpackAddress, secret);
        Jsons.ModpackContentFields latestModpackContent = ConfigTools.loadModpackContent(GlobalVariables.selectedModpackDir.resolve(GlobalVariables.hostModpackContentFile.getFileName()));
        if (optionalLatestModpackContent.isPresent() && SelfUpdater.update(latestModpackContent = optionalLatestModpackContent.get())) {
            return;
        }
        CustomFileUtils.deleteDummyFiles(Path.of(System.getProperty("user.dir"), new String[0]), latestModpackContent == null ? null : latestModpackContent.list);
        new ModpackUpdater().prepareUpdate(latestModpackContent, selectedModpackAddress, secret, GlobalVariables.selectedModpackDir);
    }

    private void initializeGlobalVariables() {
        GlobalVariables.preload = true;
        GlobalVariables.LOADER_MANAGER = new LoaderManager();
        GlobalVariables.MODPACK_LOADER = new ModpackLoader();
        GlobalVariables.MC_VERSION = GlobalVariables.LOADER_MANAGER.getModVersion("minecraft");
        GlobalVariables.AM_VERSION = ManifestReader.getAutoModpackVersion();
        GlobalVariables.LOADER_VERSION = GlobalVariables.LOADER_MANAGER.getLoaderVersion();
        GlobalVariables.LOADER = GlobalVariables.LOADER_MANAGER.getPlatformType().toString().toLowerCase();
        GlobalVariables.THIZ_JAR = FileInspection.getThizJar();
        GlobalVariables.MODS_DIR = GlobalVariables.THIZ_JAR.getParent();
        try (ZipFile zipFile = new ZipFile(GlobalVariables.THIZ_JAR.toFile());){
            ZipEntry entry = zipFile.getEntry("overrides-automodpack-client.json");
            if (entry != null) {
                GlobalVariables.clientConfigOverride = new String(zipFile.getInputStream(entry).readAllBytes());
            }
        }
        catch (IOException e) {
            GlobalVariables.LOGGER.error("Failed to open the jar file", (Throwable)e);
        }
    }

    private void loadConfigs() {
        long startTime = System.currentTimeMillis();
        if (GlobalVariables.clientConfigOverride == null) {
            GlobalVariables.clientConfig = ConfigTools.load(GlobalVariables.clientConfigFile, Jsons.ClientConfigFields.class);
        } else {
            GlobalVariables.LOGGER.warn("You are using unofficial {} mod", (Object)"automodpack");
            GlobalVariables.LOGGER.warn("Using client config overrides! Editing the {} file will have no effect", (Object)GlobalVariables.clientConfigFile);
            GlobalVariables.LOGGER.warn("Remove the {} file from inside the jar or remove and download fresh {} mod jar from modrinth/curseforge", (Object)"overrides-automodpack-client.json", (Object)"automodpack");
            GlobalVariables.clientConfig = ConfigTools.load(GlobalVariables.clientConfigOverride, Jsons.ClientConfigFields.class);
        }
        GlobalVariables.serverConfig = ConfigTools.load(GlobalVariables.serverConfigFile, Jsons.ServerConfigFields.class);
        if (GlobalVariables.serverConfig != null) {
            int previousServerConfigVersion = GlobalVariables.serverConfig.DO_NOT_CHANGE_IT;
            GlobalVariables.serverConfig.DO_NOT_CHANGE_IT = new Jsons.ServerConfigFields().DO_NOT_CHANGE_IT;
            if (previousServerConfigVersion != GlobalVariables.serverConfig.DO_NOT_CHANGE_IT) {
                GlobalVariables.LOGGER.info("Updated server config version to {}", (Object)GlobalVariables.serverConfig.DO_NOT_CHANGE_IT);
            }
            if (GlobalVariables.serverConfig.acceptedLoaders == null) {
                GlobalVariables.serverConfig.acceptedLoaders = List.of(GlobalVariables.LOADER);
            } else if (!GlobalVariables.serverConfig.acceptedLoaders.contains(GlobalVariables.LOADER)) {
                GlobalVariables.serverConfig.acceptedLoaders.add(GlobalVariables.LOADER);
            }
            if (!GlobalVariables.serverConfig.modpackName.isEmpty() && FileInspection.isInValidFileName(GlobalVariables.serverConfig.modpackName)) {
                GlobalVariables.serverConfig.modpackName = FileInspection.fixFileName(GlobalVariables.serverConfig.modpackName);
                GlobalVariables.LOGGER.info("Changed modpack name to {}", (Object)GlobalVariables.serverConfig.modpackName);
            }
            ConfigTools.save(GlobalVariables.serverConfigFile, GlobalVariables.serverConfig);
        }
        if (GlobalVariables.clientConfig != null) {
            int previousClientConfigVersion = GlobalVariables.clientConfig.DO_NOT_CHANGE_IT;
            GlobalVariables.clientConfig.DO_NOT_CHANGE_IT = new Jsons.ClientConfigFields().DO_NOT_CHANGE_IT;
            if (previousClientConfigVersion != GlobalVariables.clientConfig.DO_NOT_CHANGE_IT) {
                if (GlobalVariables.clientConfigOverride == null) {
                    GlobalVariables.LOGGER.info("Updated client config version to {}", (Object)GlobalVariables.clientConfig.DO_NOT_CHANGE_IT);
                } else {
                    GlobalVariables.LOGGER.error("Client config version is outdated!");
                }
            }
            if (GlobalVariables.clientConfig.installedModpacks == null) {
                GlobalVariables.clientConfig.installedModpacks = new HashMap<String, String>();
            }
            ConfigTools.save(GlobalVariables.clientConfigFile, GlobalVariables.clientConfig);
        }
        try {
            Files.createDirectories(GlobalVariables.privateDir, new FileAttribute[0]);
            if (Files.exists(GlobalVariables.privateDir, new LinkOption[0]) && System.getProperty("os.name").toLowerCase().contains("win")) {
                Files.setAttribute(GlobalVariables.privateDir, "dos:hidden", true, new LinkOption[0]);
            }
        }
        catch (IOException e) {
            GlobalVariables.LOGGER.error("Failed to create private directory", (Throwable)e);
        }
        if (GlobalVariables.serverConfig == null || GlobalVariables.clientConfig == null) {
            throw new RuntimeException("Failed to load config!");
        }
        GlobalVariables.LOGGER.info("Loaded config! took {}ms", (Object)(System.currentTimeMillis() - startTime));
    }
}

