/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.tomlj;

import amp_libs.org.antlr.v4.runtime.tree.ErrorNode;
import amp_libs.org.tomlj.TomlParseError;
import amp_libs.org.tomlj.TomlPosition;
import amp_libs.org.tomlj.internal.TomlParser;
import amp_libs.org.tomlj.internal.TomlParserBaseVisitor;
import java.time.LocalTime;

final class LocalTimeVisitor
extends TomlParserBaseVisitor<LocalTime> {
    private LocalTime time = LocalTime.MIN;

    LocalTimeVisitor() {
    }

    @Override
    public LocalTime visitHour(TomlParser.HourContext ctx) {
        int hour;
        String text = ctx.getText();
        if (text.length() != 2) {
            throw new TomlParseError("Invalid hour (valid range 00..23)", new TomlPosition(ctx));
        }
        try {
            hour = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid hour", new TomlPosition(ctx), e);
        }
        if (hour < 0 || hour > 23) {
            throw new TomlParseError("Invalid hour (valid range 00..23)", new TomlPosition(ctx));
        }
        this.time = this.time.withHour(hour);
        return this.time;
    }

    @Override
    public LocalTime visitMinute(TomlParser.MinuteContext ctx) {
        int minute;
        String text = ctx.getText();
        if (text.length() != 2) {
            throw new TomlParseError("Invalid minutes (valid range 00..59)", new TomlPosition(ctx));
        }
        try {
            minute = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid minutes", new TomlPosition(ctx), e);
        }
        if (minute < 0 || minute > 59) {
            throw new TomlParseError("Invalid minutes (valid range 00..59)", new TomlPosition(ctx));
        }
        this.time = this.time.withMinute(minute);
        return this.time;
    }

    @Override
    public LocalTime visitSecond(TomlParser.SecondContext ctx) {
        int second;
        String text = ctx.getText();
        if (text.length() != 2) {
            throw new TomlParseError("Invalid seconds (valid range 00..59)", new TomlPosition(ctx));
        }
        try {
            second = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid seconds", new TomlPosition(ctx), e);
        }
        if (second < 0 || second > 59) {
            throw new TomlParseError("Invalid seconds (valid range 00..59)", new TomlPosition(ctx));
        }
        this.time = this.time.withSecond(second);
        return this.time;
    }

    @Override
    public LocalTime visitSecondFraction(TomlParser.SecondFractionContext ctx) {
        int nano;
        String text = ctx.getText();
        if (text.isEmpty() || text.length() > 9) {
            throw new TomlParseError("Invalid nanoseconds (valid range 0..999999999)", new TomlPosition(ctx));
        }
        if (text.length() < 9) {
            text = text + "000000000".substring(text.length());
        }
        try {
            nano = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid nanoseconds", new TomlPosition(ctx), e);
        }
        this.time = this.time.withNano(nano);
        return this.time;
    }

    @Override
    public LocalTime visitErrorNode(ErrorNode node) {
        return null;
    }

    @Override
    protected LocalTime aggregateResult(LocalTime aggregate, LocalTime nextResult) {
        return aggregate == null ? null : nextResult;
    }

    @Override
    protected LocalTime defaultResult() {
        return this.time;
    }
}

