/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class FileSystemCapabilities {
    private static final Map<FileSystem, Boolean> SENSITIVITY_CACHE = new ConcurrentHashMap<FileSystem, Boolean>();

    private FileSystemCapabilities() {
    }

    public static boolean isCaseInsensitive() {
        return FileSystemCapabilities.isCaseInsensitive(FileSystems.getDefault());
    }

    public static boolean isCaseInsensitive(FileSystem fs) {
        if (fs == null) {
            return false;
        }
        return SENSITIVITY_CACHE.computeIfAbsent(fs, FileSystemCapabilities::probeSensitivity);
    }

    private static boolean probeSensitivity(FileSystem fs) {
        try {
            Path p1 = fs.getPath("A", new String[0]);
            Path p2 = fs.getPath("a", new String[0]);
            if (p1.equals(p2)) {
                return true;
            }
            return p1.hashCode() == p2.hashCode();
        }
        catch (Exception e) {
            return false;
        }
    }
}

