/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record SemanticVersion(int major, int minor, int patch, String label, int preVersion) implements Comparable<SemanticVersion>
{
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)(?:-(.+))?$");
    private static final Pattern PRE_SPLIT_PATTERN = Pattern.compile("^([a-zA-Z]+)(?:[.\\-]?)(\\d+)?$");

    public static SemanticVersion parse(String versionString) {
        if (versionString == null || versionString.isBlank()) {
            throw new IllegalArgumentException("Version cannot be empty");
        }
        Matcher matcher = VERSION_PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid version format: " + versionString);
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Integer.parseInt(matcher.group(3));
        String rawPre = matcher.group(4);
        if (rawPre == null) {
            return new SemanticVersion(major, minor, patch, "release", Integer.MAX_VALUE);
        }
        Matcher preMatcher = PRE_SPLIT_PATTERN.matcher(rawPre);
        String label = rawPre;
        int preVer = 1;
        if (preMatcher.find()) {
            label = preMatcher.group(1).toLowerCase();
            String numPart = preMatcher.group(2);
            if (numPart != null) {
                preVer = Integer.parseInt(numPart);
            }
        }
        return new SemanticVersion(major, minor, patch, label, preVer);
    }

    public boolean isStable() {
        return "release".equals(this.label);
    }

    private int getLabelWeight() {
        return switch (this.label) {
            case "release" -> 100;
            case "rc", "pre" -> 50;
            case "beta" -> 30;
            case "alpha" -> 10;
            case "snapshot" -> 5;
            default -> 0;
        };
    }

    @Override
    public int compareTo(SemanticVersion o) {
        int otherWeight;
        if (this.major != o.major) {
            return Integer.compare(this.major, o.major);
        }
        if (this.minor != o.minor) {
            return Integer.compare(this.minor, o.minor);
        }
        if (this.patch != o.patch) {
            return Integer.compare(this.patch, o.patch);
        }
        int thisWeight = this.getLabelWeight();
        if (thisWeight != (otherWeight = o.getLabelWeight())) {
            return Integer.compare(thisWeight, otherWeight);
        }
        return Integer.compare(this.preVersion, o.preVersion);
    }

    @Override
    public String toString() {
        if (this.isStable()) {
            return String.format("%d.%d.%d", this.major, this.minor, this.patch);
        }
        return String.format("%d.%d.%d-%s.%d", this.major, this.minor, this.patch, this.label, this.preVersion);
    }
}

