/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.apache.hc.client5.http.impl.auth;

import am_libs.org.apache.hc.client5.http.auth.AuthScope;
import am_libs.org.apache.hc.client5.http.auth.Credentials;
import am_libs.org.apache.hc.client5.http.auth.CredentialsStore;
import am_libs.org.apache.hc.client5.http.impl.auth.CredentialsMatcher;
import am_libs.org.apache.hc.core5.annotation.Contract;
import am_libs.org.apache.hc.core5.annotation.ThreadingBehavior;
import am_libs.org.apache.hc.core5.http.protocol.HttpContext;
import am_libs.org.apache.hc.core5.util.Args;
import java.util.concurrent.ConcurrentHashMap;

@Contract(threading=ThreadingBehavior.SAFE)
public class BasicCredentialsProvider
implements CredentialsStore {
    private final ConcurrentHashMap<AuthScope, Credentials> credMap = new ConcurrentHashMap();

    @Override
    public void setCredentials(AuthScope authScope, Credentials credentials) {
        Args.notNull(authScope, "Authentication scope");
        this.credMap.put(authScope, credentials);
    }

    @Override
    public Credentials getCredentials(AuthScope authScope, HttpContext context) {
        return CredentialsMatcher.matchCredentials(this.credMap, authScope);
    }

    @Override
    public void clear() {
        this.credMap.clear();
    }

    public String toString() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.credMap.keySet())).toString();
    }
}

