/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.List;
import java.util.Map;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.protocol.compression.CompressionCodec;
import pl.skidam.automodpack_core.protocol.compression.CompressionFactory;
import pl.skidam.automodpack_core.protocol.netty.NettyServer;
import pl.skidam.automodpack_core.protocol.netty.TrafficShaper;
import pl.skidam.automodpack_core.protocol.netty.handler.CompressionDecoder;
import pl.skidam.automodpack_core.protocol.netty.handler.CompressionEncoder;
import pl.skidam.automodpack_core.protocol.netty.handler.ErrorPrinter;
import pl.skidam.automodpack_core.protocol.netty.handler.ProtocolMessageDecoder;
import pl.skidam.automodpack_core.protocol.netty.handler.ServerMessageHandler;
import pl.skidam.automodpack_core.utils.PlatformUtils;

public class ProtocolServerHandler
extends ByteToMessageDecoder {
    private final SslContext sslCtx;

    public ProtocolServerHandler(SslContext sslCtx) {
        this.sslCtx = sslCtx;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 4) {
            return;
        }
        int magic = in.getInt(0);
        if (magic == 1095585091) {
            byte negotiatedProtocolVersion = 2;
            byte negotiatedCompressionType = 1;
            if (in.readableBytes() >= 6) {
                in.skipBytes(4);
                byte clientProtocolVersion = in.readByte();
                byte clientCompressionType = in.readByte();
                byte by = negotiatedProtocolVersion = clientProtocolVersion >= 2 ? (byte)2 : 1;
                if (clientCompressionType == 1 || clientCompressionType == 2 || clientCompressionType == 0) {
                    negotiatedCompressionType = PlatformUtils.isAndroid() && clientCompressionType == 1 ? (byte)2 : clientCompressionType;
                }
                ByteBuf response = ctx.alloc().buffer(6);
                response.writeInt(1095585611);
                response.writeByte((int)negotiatedProtocolVersion);
                response.writeByte((int)negotiatedCompressionType);
                ctx.writeAndFlush((Object)response);
                ctx.pipeline().channel().attr(NettyServer.PROTOCOL_VERSION).set((Object)negotiatedProtocolVersion);
                ctx.pipeline().channel().attr(NettyServer.COMPRESSION_TYPE).set((Object)negotiatedCompressionType);
            } else {
                in.skipBytes(4);
                ByteBuf response = ctx.alloc().buffer(4);
                response.writeInt(1095585611);
                ctx.writeAndFlush((Object)response);
                negotiatedProtocolVersion = 1;
                ctx.pipeline().channel().attr(NettyServer.PROTOCOL_VERSION).set((Object)negotiatedProtocolVersion);
                ctx.pipeline().channel().attr(NettyServer.COMPRESSION_TYPE).set((Object)negotiatedCompressionType);
            }
            Map handlers = ctx.pipeline().toMap();
            handlers.forEach((name, handler) -> ctx.pipeline().remove(handler));
            GlobalVariables.LOGGER.debug("New connection, negotiated version: {}, negotiated compression: {}", (Object)negotiatedProtocolVersion, (Object)negotiatedCompressionType);
            this.setupPipeline(ctx, negotiatedCompressionType);
        } else if (this.sslCtx == null || GlobalVariables.serverConfig.bindPort != -1) {
            ctx.pipeline().channel().attr(NettyServer.PROTOCOL_VERSION).set((Object)1);
            ctx.pipeline().channel().attr(NettyServer.COMPRESSION_TYPE).set((Object)1);
            this.setupPipeline(ctx, (byte)1);
        }
        if (ctx.pipeline().get(((Object)((Object)this)).getClass()) != null) {
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    private void setupPipeline(ChannelHandlerContext ctx, byte compressionType) {
        ctx.pipeline().addLast("error-printer-first", (ChannelHandler)new ErrorPrinter());
        ctx.pipeline().addLast("traffic-shaper", (ChannelHandler)TrafficShaper.trafficShaper.getTrafficShapingHandler());
        if (this.sslCtx != null) {
            ctx.pipeline().addLast("tls", (ChannelHandler)this.sslCtx.newHandler(ctx.alloc()));
        }
        CompressionCodec codec = CompressionFactory.getCodec(compressionType);
        ctx.pipeline().addLast("compression-encoder", (ChannelHandler)new CompressionEncoder(codec)).addLast("compression-decoder", (ChannelHandler)new CompressionDecoder(codec)).addLast("chunked-write", (ChannelHandler)new ChunkedWriteHandler()).addLast("protocol-msg-decoder", (ChannelHandler)new ProtocolMessageDecoder()).addLast("msg-handler", (ChannelHandler)new ServerMessageHandler()).addLast("error-printer-last", (ChannelHandler)new ErrorPrinter());
    }
}

