/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.auth.Secrets;
import pl.skidam.automodpack_core.modpack.ModpackContent;
import pl.skidam.automodpack_core.protocol.netty.NettyServer;
import pl.skidam.automodpack_core.protocol.netty.message.EchoMessage;
import pl.skidam.automodpack_core.protocol.netty.message.FileRequestMessage;
import pl.skidam.automodpack_core.protocol.netty.message.ProtocolMessage;
import pl.skidam.automodpack_core.protocol.netty.message.RefreshRequestMessage;

public class ServerMessageHandler
extends SimpleChannelInboundHandler<ProtocolMessage> {
    private final Map<byte[], String> secretLookup = new HashMap<byte[], String>();

    public void handlerRemoved(ChannelHandlerContext ctx) {
        GlobalVariables.hostServer.removeConnection(ctx.channel());
    }

    protected void channelRead0(ChannelHandlerContext ctx, ProtocolMessage msg) throws Exception {
        byte clientProtocolVersion = msg.getVersion();
        SocketAddress address = ctx.channel().remoteAddress();
        if (!this.validateSecret(ctx, address, msg.getSecret())) {
            this.sendError(ctx, clientProtocolVersion, "Authentication failed");
            return;
        }
        switch (msg.getType()) {
            case 0: {
                EchoMessage echoMsg = (EchoMessage)msg;
                ByteBuf echoBuf = Unpooled.buffer((int)(2 + msg.getSecret().length + echoMsg.getData().length));
                echoBuf.writeByte((int)clientProtocolVersion);
                echoBuf.writeByte(0);
                echoBuf.writeBytes(echoMsg.getSecret());
                echoBuf.writeBytes(echoMsg.getData());
                ctx.writeAndFlush((Object)echoBuf);
                ctx.channel().close();
                break;
            }
            case 1: {
                FileRequestMessage fileRequest = (FileRequestMessage)msg;
                this.sendFile(ctx, fileRequest.getFileHash());
                break;
            }
            case 3: {
                RefreshRequestMessage refreshRequest = (RefreshRequestMessage)msg;
                this.refreshModpackFiles(ctx, refreshRequest.getFileHashesList());
                break;
            }
            default: {
                this.sendError(ctx, clientProtocolVersion, "Unknown message type");
            }
        }
    }

    private void refreshModpackFiles(ChannelHandlerContext context, byte[][] FileHashesList) throws IOException {
        ArrayList<String> hashes = new ArrayList<String>();
        for (Object hash : FileHashesList) {
            hashes.add(new String((byte[])hash));
        }
        GlobalVariables.LOGGER.info("Received refresh request for files of hashes: {}", hashes);
        ArrayList<CompletableFuture<Void>> creationFutures = new ArrayList<CompletableFuture<Void>>();
        ArrayList<ModpackContent> modpacks = new ArrayList<ModpackContent>();
        Iterator iterator = hashes.iterator();
        while (iterator.hasNext()) {
            Object hash;
            hash = (String)iterator.next();
            Optional<Path> optionalPath = this.resolvePath((String)hash);
            if (optionalPath.isEmpty()) continue;
            Path path = optionalPath.get();
            ModpackContent modpack = null;
            for (ModpackContent content : GlobalVariables.modpackExecutor.modpacks.values()) {
                if (!content.pathsMap.getMap().containsKey(hash)) continue;
                modpack = content;
                break;
            }
            if (modpack == null) continue;
            modpacks.add(modpack);
            creationFutures.add(modpack.replaceAsync(path));
        }
        creationFutures.forEach(CompletableFuture::join);
        modpacks.forEach(ModpackContent::saveModpackContent);
        GlobalVariables.LOGGER.info("Sending new modpack-content.json");
        this.sendFile(context, new byte[0]);
    }

    private boolean validateSecret(ChannelHandlerContext ctx, SocketAddress address, byte[] secret) {
        String decodedSecret = this.secretLookup.get(secret);
        boolean addConnection = false;
        if (decodedSecret == null) {
            decodedSecret = Base64.getUrlEncoder().withoutPadding().encodeToString(secret);
            addConnection = true;
            this.secretLookup.put(secret, decodedSecret);
        }
        boolean valid = Secrets.isSecretValid(decodedSecret, address);
        if (addConnection && valid) {
            GlobalVariables.hostServer.addConnection(ctx.channel(), decodedSecret);
        }
        return valid;
    }

    private void sendFile(ChannelHandlerContext ctx, byte[] bsha1) throws IOException {
        String sha1 = new String(bsha1, CharsetUtil.UTF_8);
        Optional<Path> optionalPath = this.resolvePath(sha1);
        byte protocolVersion = (Byte)ctx.pipeline().channel().attr(NettyServer.PROTOCOL_VERSION).get();
        if (optionalPath.isEmpty() || !Files.exists(optionalPath.get(), new LinkOption[0])) {
            this.sendError(ctx, protocolVersion, "File not found");
            return;
        }
        Path path = optionalPath.get();
        long fileSize = Files.size(path);
        ByteBuf responseHeader = Unpooled.buffer((int)10);
        responseHeader.writeByte((int)protocolVersion);
        responseHeader.writeByte(2);
        responseHeader.writeLong(fileSize);
        ctx.writeAndFlush((Object)responseHeader);
        if (fileSize == 0L) {
            this.sendEOT(ctx);
            return;
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(path.toFile(), "r");
            ChunkedFile chunkedFile = new ChunkedFile(raf, 0L, raf.length(), 131072);
            ctx.writeAndFlush((Object)chunkedFile).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                try {
                    if (future.isSuccess()) {
                        this.sendEOT(ctx);
                    } else {
                        this.sendError(ctx, protocolVersion, "File transfer error: " + future.cause().getMessage());
                    }
                }
                finally {
                    try {
                        chunkedFile.close();
                        raf.close();
                    }
                    catch (IOException e) {
                        GlobalVariables.LOGGER.error("Error closing file resources", (Throwable)e);
                    }
                }
            }));
        }
        catch (IOException e) {
            this.sendError(ctx, protocolVersion, "File transfer error: " + e.getMessage());
        }
    }

    public Optional<Path> resolvePath(String sha1) {
        if (sha1.isBlank()) {
            return Optional.of(GlobalVariables.hostModpackContentFile);
        }
        return GlobalVariables.hostServer.getPath(sha1);
    }

    private void sendError(ChannelHandlerContext ctx, byte version, String errorMessage) {
        byte[] errMsgBytes = errorMessage.getBytes(CharsetUtil.UTF_8);
        ByteBuf errorBuf = Unpooled.buffer((int)(6 + errMsgBytes.length));
        errorBuf.writeByte((int)version);
        errorBuf.writeByte(5);
        errorBuf.writeInt(errMsgBytes.length);
        errorBuf.writeBytes(errMsgBytes);
        ctx.writeAndFlush((Object)errorBuf);
        ctx.channel().close();
    }

    private void sendEOT(ChannelHandlerContext ctx) {
        byte protocolVersion = (Byte)ctx.pipeline().channel().attr(NettyServer.PROTOCOL_VERSION).get();
        ByteBuf eot = Unpooled.buffer((int)2);
        eot.writeByte((int)protocolVersion);
        eot.writeByte(4);
        ctx.writeAndFlush((Object)eot);
    }
}

