/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol;

import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import pl.skidam.automodpack_core.auth.Secrets;
import pl.skidam.automodpack_core.callbacks.IntCallback;
import pl.skidam.automodpack_core.protocol.Connection;

public class DownloadClient {
    private final List<Connection> connections = new ArrayList<Connection>();

    public DownloadClient(InetSocketAddress address, Secrets.Secret secret, int poolSize) throws Exception {
        for (int i = 0; i < poolSize; ++i) {
            this.connections.add(new Connection(address, secret));
        }
    }

    private synchronized Connection getFreeConnection() {
        Iterator<Connection> iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection conn = iterator.next();
            if (conn.isBusy()) continue;
            if (!conn.isActive()) {
                iterator.remove();
                return this.getFreeConnection();
            }
            conn.setBusy(true);
            return conn;
        }
        throw new IllegalStateException("No available connections");
    }

    public CompletableFuture<Path> downloadFile(byte[] fileHash, Path destination, IntCallback chunkCallback) {
        Connection conn = this.getFreeConnection();
        return conn.sendDownloadFile(fileHash, destination, chunkCallback);
    }

    public CompletableFuture<Path> requestRefresh(byte[][] fileHashes, Path destination) {
        Connection conn = this.getFreeConnection();
        return conn.sendRefreshRequest(fileHashes, destination);
    }

    public void close() {
        for (Connection conn : this.connections) {
            conn.close();
        }
        this.connections.clear();
    }
}

