/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core.utils;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.protocol.DownloadClient;
import pl.skidam.automodpack_core.utils.CustomFileUtils;
import pl.skidam.automodpack_core.utils.CustomThreadFactoryBuilder;
import pl.skidam.automodpack_core.utils.FileInspection;
import pl.skidam.automodpack_loader_core.utils.SpeedMeter;

public class DownloadManager {
    private static final int MAX_DOWNLOADS_IN_PROGRESS = 5;
    private static final int MAX_DOWNLOAD_ATTEMPTS = 2;
    private static final int BUFFER_SIZE = 131072;
    private final ExecutorService DOWNLOAD_EXECUTOR = Executors.newFixedThreadPool(5, new CustomThreadFactoryBuilder().setNameFormat("AutoModpackDownload-%d").build());
    private DownloadClient downloadClient = null;
    private boolean cancelled = false;
    private final Map<FileInspection.HashPathPair, QueuedDownload> queuedDownloads = new ConcurrentHashMap<FileInspection.HashPathPair, QueuedDownload>();
    public final Map<FileInspection.HashPathPair, DownloadData> downloadsInProgress = new ConcurrentHashMap<FileInspection.HashPathPair, DownloadData>();
    private long bytesDownloaded = 0L;
    private long bytesToDownload = 0L;
    private int addedToQueue = 0;
    private int downloaded = 0;
    private final Semaphore semaphore = new Semaphore(0);
    private final SpeedMeter speedMeter = new SpeedMeter(this);

    public DownloadManager() {
    }

    public DownloadManager(long bytesToDownload) {
        this.bytesToDownload = bytesToDownload;
    }

    public void attachDownloadClient(DownloadClient downloadClient) {
        this.downloadClient = downloadClient;
    }

    public void download(Path file, String sha1, List<String> urls, Runnable successCallback, Runnable failureCallback) {
        FileInspection.HashPathPair hashPathPair = new FileInspection.HashPathPair(sha1, file);
        if (this.queuedDownloads.containsKey(hashPathPair)) {
            return;
        }
        this.queuedDownloads.put(hashPathPair, new QueuedDownload(file, urls, 0, successCallback, failureCallback));
        ++this.addedToQueue;
        this.downloadNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadTask(FileInspection.HashPathPair hashPathPair, QueuedDownload queuedDownload) throws Exception {
        GlobalVariables.LOGGER.info("Downloading {} - {}", (Object)queuedDownload.file.getFileName(), queuedDownload.urls);
        int numberOfIndexes = queuedDownload.urls.size();
        int urlIndex = Math.min(queuedDownload.attempts / 2, numberOfIndexes);
        String url = "host";
        if (queuedDownload.urls.size() > urlIndex) {
            url = queuedDownload.urls.get(urlIndex);
        }
        boolean interrupted = false;
        try {
            if (url != null && !Objects.equals(url, "host") && queuedDownload.attempts < 2 * numberOfIndexes) {
                this.httpDownloadFile(url, hashPathPair, queuedDownload);
            } else if (this.downloadClient != null) {
                this.hostDownloadFile(hashPathPair, queuedDownload);
            } else {
                GlobalVariables.LOGGER.error("No download client attached, can't download file - {}", (Object)queuedDownload.file.getFileName());
            }
        }
        catch (InterruptedException e) {
            interrupted = true;
        }
        catch (SocketTimeoutException e) {
            GlobalVariables.LOGGER.warn("Timeout - {} - {} - {}", (Object)queuedDownload.file, (Object)e, (Object)e.fillInStackTrace());
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.warn("Error while downloading file - {} - {} - {}", (Object)queuedDownload.file, (Object)e, (Object)e.fillInStackTrace());
        }
        finally {
            Object hash;
            Map<FileInspection.HashPathPair, DownloadData> e = this.downloadsInProgress;
            synchronized (e) {
                this.downloadsInProgress.remove(hashPathPair);
            }
            boolean failed = true;
            if (Files.exists(queuedDownload.file, new LinkOption[0]) && Objects.equals(hash = CustomFileUtils.getHash(queuedDownload.file), hashPathPair.hash())) {
                failed = false;
                ++this.downloaded;
                GlobalVariables.LOGGER.info("Successfully downloaded {} from {}", (Object)queuedDownload.file.getFileName(), (Object)url);
                queuedDownload.successCallback.run();
                this.semaphore.release();
            }
            if (failed) {
                this.bytesToDownload += queuedDownload.file.toFile().length();
                CustomFileUtils.forceDelete(queuedDownload.file);
                if (!interrupted) {
                    if (queuedDownload.attempts < (numberOfIndexes + 1) * 2) {
                        GlobalVariables.LOGGER.warn("Download of {} failed, retrying!", (Object)queuedDownload.file.getFileName());
                        ++queuedDownload.attempts;
                        hash = this.queuedDownloads;
                        synchronized (hash) {
                            this.queuedDownloads.put(hashPathPair, queuedDownload);
                        }
                    } else {
                        GlobalVariables.LOGGER.error("Download of {} failed!", (Object)queuedDownload.file.getFileName());
                        queuedDownload.failureCallback.run();
                        this.semaphore.release();
                    }
                }
            }
            if (!interrupted) {
                this.downloadNext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void downloadNext() {
        if (this.downloadsInProgress.size() < 5 && !this.queuedDownloads.isEmpty()) {
            FileInspection.HashPathPair hashAndPath = (FileInspection.HashPathPair)this.queuedDownloads.keySet().stream().findFirst().get();
            QueuedDownload queuedDownload = this.queuedDownloads.remove(hashAndPath);
            if (queuedDownload == null) {
                return;
            }
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                try {
                    this.downloadTask(hashAndPath, queuedDownload);
                }
                catch (Exception e) {
                    GlobalVariables.LOGGER.error("Error while downloading file - {}", (Object)queuedDownload.file.getFileName(), (Object)e);
                }
            }, this.DOWNLOAD_EXECUTOR);
            Map<FileInspection.HashPathPair, DownloadData> map = this.downloadsInProgress;
            synchronized (map) {
                this.downloadsInProgress.put(hashAndPath, new DownloadData(future, queuedDownload.file));
            }
        }
    }

    private void hostDownloadFile(FileInspection.HashPathPair hashPathPair, QueuedDownload queuedDownload) throws IOException, InterruptedException {
        Path outFile = queuedDownload.file;
        if (Files.exists(outFile, new LinkOption[0])) {
            if (Objects.equals(hashPathPair.hash(), CustomFileUtils.getHash(outFile))) {
                return;
            }
            CustomFileUtils.forceDelete(outFile);
        }
        CustomFileUtils.setupFilePaths(outFile);
        CompletableFuture<Path> future = this.downloadClient.downloadFile(hashPathPair.hash().getBytes(StandardCharsets.UTF_8), outFile, bytes -> {
            this.bytesDownloaded += (long)bytes;
            this.speedMeter.addDownloadedBytes(bytes);
        });
        future.join();
    }

    private void httpDownloadFile(String url, FileInspection.HashPathPair hashPathPair, QueuedDownload queuedDownload) throws IOException, InterruptedException {
        Path outFile = queuedDownload.file;
        if (Files.exists(outFile, new LinkOption[0])) {
            if (Objects.equals(hashPathPair.hash(), CustomFileUtils.getHash(outFile))) {
                return;
            }
            CustomFileUtils.forceDelete(outFile);
        }
        CustomFileUtils.setupFilePaths(outFile);
        URLConnection connection = this.getHttpConnection(url);
        try (FileOutputStream outputStream = new FileOutputStream(outFile.toFile());
             BufferedInputStream rawInputStream = new BufferedInputStream(connection.getInputStream(), 131072);
             FilterInputStream inputStream = "gzip".equals(connection.getHeaderField("Content-Encoding")) ? new GZIPInputStream(rawInputStream) : rawInputStream;){
            int bytesRead;
            byte[] buffer = new byte[131072];
            while ((bytesRead = ((InputStream)inputStream).read(buffer)) != -1) {
                this.bytesDownloaded += (long)bytesRead;
                this.speedMeter.addDownloadedBytes(bytesRead);
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException("Download got cancelled");
            }
        }
    }

    private URLConnection getHttpConnection(String url) throws IOException {
        GlobalVariables.LOGGER.info("Downloading from {}", (Object)url);
        URL connectionUrl = new URL(url);
        URLConnection connection = connectionUrl.openConnection();
        connection.addRequestProperty("Accept-Encoding", "gzip");
        connection.addRequestProperty("User-Agent", "github/skidamek/automodpack/" + GlobalVariables.AM_VERSION);
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        return connection;
    }

    public void joinAll() throws InterruptedException {
        this.semaphore.acquire(this.addedToQueue);
        if (this.DOWNLOAD_EXECUTOR.isShutdown()) {
            throw new InterruptedException();
        }
        this.semaphore.release(this.addedToQueue);
    }

    public SpeedMeter getSpeedMeter() {
        return this.speedMeter;
    }

    public long getTotalBytesRemaining() {
        return this.bytesToDownload - this.bytesDownloaded;
    }

    public float getTotalPercentageOfFileSizeDownloaded() {
        return (float)this.bytesDownloaded / (float)this.bytesToDownload * 100.0f;
    }

    public String getStage() {
        return this.downloaded + "/" + this.addedToQueue;
    }

    public boolean isRunning() {
        return !this.DOWNLOAD_EXECUTOR.isShutdown();
    }

    public boolean isCanceled() {
        return this.cancelled;
    }

    public void cancelAllAndShutdown() {
        this.cancelled = true;
        this.queuedDownloads.clear();
        this.downloadsInProgress.forEach((url, downloadData) -> {
            downloadData.future.cancel(true);
            CustomFileUtils.forceDelete(downloadData.file);
        });
        this.semaphore.release(this.addedToQueue);
        this.downloadsInProgress.clear();
        this.downloaded = 0;
        this.addedToQueue = 0;
        if (this.downloadClient != null) {
            this.downloadClient.close();
        }
        this.DOWNLOAD_EXECUTOR.shutdownNow();
        try {
            if (!this.DOWNLOAD_EXECUTOR.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.DOWNLOAD_EXECUTOR.shutdownNow();
                if (!this.DOWNLOAD_EXECUTOR.awaitTermination(3L, TimeUnit.SECONDS)) {
                    GlobalVariables.LOGGER.error("DOWNLOAD EXECUTOR did not terminate");
                }
            }
        }
        catch (InterruptedException e) {
            this.DOWNLOAD_EXECUTOR.shutdownNow();
        }
    }

    public static class QueuedDownload {
        private final Path file;
        private final List<String> urls;
        private int attempts;
        private final Runnable successCallback;
        private final Runnable failureCallback;

        public QueuedDownload(Path file, List<String> urls, int attempts, Runnable successCallback, Runnable failureCallback) {
            this.file = file;
            this.urls = urls;
            this.attempts = attempts;
            this.successCallback = successCallback;
            this.failureCallback = failureCallback;
        }
    }

    public static class DownloadData {
        public CompletableFuture<Void> future;
        public Path file;

        DownloadData(CompletableFuture<Void> future, Path file) {
            this.future = future;
            this.file = file;
        }

        public String getFileName() {
            return this.file.getFileName().toString();
        }
    }
}

