/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.apache.hc.client5.http.impl.classic;

import am_libs.org.apache.hc.client5.http.ClientProtocolException;
import am_libs.org.apache.hc.client5.http.HttpRoute;
import am_libs.org.apache.hc.client5.http.SchemePortResolver;
import am_libs.org.apache.hc.client5.http.config.Configurable;
import am_libs.org.apache.hc.client5.http.config.RequestConfig;
import am_libs.org.apache.hc.client5.http.impl.ConnectionShutdownException;
import am_libs.org.apache.hc.client5.http.impl.DefaultClientConnectionReuseStrategy;
import am_libs.org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import am_libs.org.apache.hc.client5.http.impl.ExecSupport;
import am_libs.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import am_libs.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import am_libs.org.apache.hc.client5.http.impl.classic.InternalExecRuntime;
import am_libs.org.apache.hc.client5.http.impl.classic.ResponseEntityProxy;
import am_libs.org.apache.hc.client5.http.io.HttpClientConnectionManager;
import am_libs.org.apache.hc.client5.http.protocol.HttpClientContext;
import am_libs.org.apache.hc.client5.http.protocol.RequestClientConnControl;
import am_libs.org.apache.hc.client5.http.routing.RoutingSupport;
import am_libs.org.apache.hc.core5.annotation.Contract;
import am_libs.org.apache.hc.core5.annotation.ThreadingBehavior;
import am_libs.org.apache.hc.core5.concurrent.CancellableDependency;
import am_libs.org.apache.hc.core5.http.ClassicHttpRequest;
import am_libs.org.apache.hc.core5.http.ClassicHttpResponse;
import am_libs.org.apache.hc.core5.http.ConnectionReuseStrategy;
import am_libs.org.apache.hc.core5.http.EntityDetails;
import am_libs.org.apache.hc.core5.http.HttpEntity;
import am_libs.org.apache.hc.core5.http.HttpException;
import am_libs.org.apache.hc.core5.http.HttpHost;
import am_libs.org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import am_libs.org.apache.hc.core5.http.protocol.DefaultHttpProcessor;
import am_libs.org.apache.hc.core5.http.protocol.HttpContext;
import am_libs.org.apache.hc.core5.http.protocol.HttpProcessor;
import am_libs.org.apache.hc.core5.http.protocol.RequestContent;
import am_libs.org.apache.hc.core5.http.protocol.RequestTargetHost;
import am_libs.org.apache.hc.core5.http.protocol.RequestUserAgent;
import am_libs.org.apache.hc.core5.io.CloseMode;
import am_libs.org.apache.hc.core5.net.URIAuthority;
import am_libs.org.apache.hc.core5.util.Args;
import am_libs.org.apache.hc.core5.util.TimeValue;
import am_libs.org.apache.hc.core5.util.VersionInfo;
import am_libs.org.slf4j.Logger;
import am_libs.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InterruptedIOException;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class MinimalHttpClient
extends CloseableHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(MinimalHttpClient.class);
    private final HttpClientConnectionManager connManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final SchemePortResolver schemePortResolver;
    private final HttpRequestExecutor requestExecutor;
    private final HttpProcessor httpProcessor;

    MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.reuseStrategy = DefaultClientConnectionReuseStrategy.INSTANCE;
        this.schemePortResolver = DefaultSchemePortResolver.INSTANCE;
        this.requestExecutor = new HttpRequestExecutor(this.reuseStrategy);
        this.httpProcessor = new DefaultHttpProcessor(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(VersionInfo.getSoftwareInfo("Apache-HttpClient", "am_libs.org.apache.hc.client5", this.getClass())));
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, ClassicHttpRequest request, HttpContext context) throws IOException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        if (request.getScheme() == null) {
            request.setScheme(target.getSchemeName());
        }
        if (request.getAuthority() == null) {
            request.setAuthority(new URIAuthority(target));
        }
        HttpClientContext clientContext = HttpClientContext.castOrCreate(context);
        RequestConfig config = null;
        if (request instanceof Configurable) {
            config = ((Configurable)((Object)request)).getConfig();
        }
        if (config != null) {
            clientContext.setRequestConfig(config);
        }
        HttpRoute route = new HttpRoute(RoutingSupport.normalize(target, this.schemePortResolver));
        String exchangeId = ExecSupport.getNextExchangeId();
        clientContext.setExchangeId(exchangeId);
        InternalExecRuntime execRuntime = new InternalExecRuntime(LOG, this.connManager, this.requestExecutor, request instanceof CancellableDependency ? (CancellableDependency)((Object)request) : null);
        try {
            if (!execRuntime.isEndpointAcquired()) {
                execRuntime.acquireEndpoint(exchangeId, route, null, clientContext);
            }
            if (!execRuntime.isEndpointConnected()) {
                execRuntime.connectEndpoint(clientContext);
            }
            clientContext.setRequest(request);
            clientContext.setRoute(route);
            this.httpProcessor.process(request, (EntityDetails)request.getEntity(), (HttpContext)clientContext);
            ClassicHttpResponse response = execRuntime.execute(exchangeId, request, clientContext);
            this.httpProcessor.process(response, (EntityDetails)response.getEntity(), (HttpContext)clientContext);
            if (this.reuseStrategy.keepAlive(request, response, clientContext)) {
                execRuntime.markConnectionReusable(null, TimeValue.NEG_ONE_MILLISECOND);
            } else {
                execRuntime.markConnectionNonReusable();
            }
            HttpEntity entity = response.getEntity();
            if (entity == null || !entity.isStreaming()) {
                execRuntime.releaseEndpoint();
                return new CloseableHttpResponse(response);
            }
            ResponseEntityProxy.enhance(response, execRuntime);
            return new CloseableHttpResponse(response, execRuntime);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            execRuntime.discardEndpoint();
            throw ioex;
        }
        catch (HttpException httpException) {
            execRuntime.discardEndpoint();
            throw new ClientProtocolException(httpException);
        }
        catch (IOException | RuntimeException ex) {
            execRuntime.discardEndpoint();
            throw ex;
        }
        catch (Error error) {
            this.connManager.close(CloseMode.IMMEDIATE);
            throw error;
        }
    }

    @Override
    public void close() throws IOException {
        this.connManager.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.connManager.close(closeMode);
    }
}

