/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.apache.hc.core5.http.nio.support;

import am_libs.org.apache.hc.core5.concurrent.CallbackContribution;
import am_libs.org.apache.hc.core5.concurrent.FutureCallback;
import am_libs.org.apache.hc.core5.function.Supplier;
import am_libs.org.apache.hc.core5.http.EntityDetails;
import am_libs.org.apache.hc.core5.http.Header;
import am_libs.org.apache.hc.core5.http.HttpException;
import am_libs.org.apache.hc.core5.http.HttpResponse;
import am_libs.org.apache.hc.core5.http.Message;
import am_libs.org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import am_libs.org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import am_libs.org.apache.hc.core5.http.nio.CapacityChannel;
import am_libs.org.apache.hc.core5.http.protocol.HttpContext;
import am_libs.org.apache.hc.core5.util.Args;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class BasicResponseConsumer<T>
implements AsyncResponseConsumer<Message<HttpResponse, T>> {
    private final Supplier<AsyncEntityConsumer<T>> dataConsumerSupplier;
    private final AtomicReference<AsyncEntityConsumer<T>> dataConsumerRef;

    public BasicResponseConsumer(Supplier<AsyncEntityConsumer<T>> dataConsumerSupplier) {
        this.dataConsumerSupplier = Args.notNull(dataConsumerSupplier, "Data consumer supplier");
        this.dataConsumerRef = new AtomicReference();
    }

    public BasicResponseConsumer(AsyncEntityConsumer<T> dataConsumer) {
        this(() -> dataConsumer);
    }

    @Override
    public void consumeResponse(final HttpResponse response, EntityDetails entityDetails, HttpContext httpContext, final FutureCallback<Message<HttpResponse, T>> resultCallback) throws HttpException, IOException {
        Args.notNull(response, "Response");
        if (entityDetails != null) {
            AsyncEntityConsumer<T> dataConsumer = this.dataConsumerSupplier.get();
            if (dataConsumer == null) {
                throw new HttpException("Supplied data consumer is null");
            }
            this.dataConsumerRef.set(dataConsumer);
            dataConsumer.streamStart(entityDetails, new CallbackContribution<T>(resultCallback){

                @Override
                public void completed(T body) {
                    if (resultCallback != null) {
                        resultCallback.completed(new Message(response, body));
                    }
                }
            });
        } else if (resultCallback != null) {
            resultCallback.completed(new Message(response));
        }
    }

    @Override
    public void informationResponse(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        AsyncEntityConsumer<T> dataConsumer = this.dataConsumerRef.get();
        dataConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public void consume(ByteBuffer src) throws IOException {
        AsyncEntityConsumer<T> dataConsumer = this.dataConsumerRef.get();
        dataConsumer.consume(src);
    }

    @Override
    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        AsyncEntityConsumer<T> dataConsumer = this.dataConsumerRef.get();
        dataConsumer.streamEnd(trailers);
    }

    @Override
    public void failed(Exception cause) {
        AsyncEntityConsumer<T> dataConsumer = this.dataConsumerRef.get();
        if (dataConsumer != null) {
            dataConsumer.failed(cause);
        }
        this.releaseResources();
    }

    @Override
    public void releaseResources() {
        AsyncEntityConsumer dataConsumer = this.dataConsumerRef.getAndSet(null);
        if (dataConsumer != null) {
            dataConsumer.releaseResources();
        }
    }
}

