/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.pqc.jcajce.provider.snova;

import am_libs.org.bouncycastle.asn1.ASN1Set;
import am_libs.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import am_libs.org.bouncycastle.pqc.crypto.snova.SnovaPrivateKeyParameters;
import am_libs.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import am_libs.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import am_libs.org.bouncycastle.pqc.jcajce.interfaces.SnovaKey;
import am_libs.org.bouncycastle.pqc.jcajce.spec.SnovaParameterSpec;
import am_libs.org.bouncycastle.util.Arrays;
import am_libs.org.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BCSnovaPrivateKey
implements PrivateKey,
SnovaKey {
    private static final long serialVersionUID = 1L;
    private transient SnovaPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCSnovaPrivateKey(SnovaPrivateKeyParameters snovaPrivateKeyParameters) {
        this.params = snovaPrivateKeyParameters;
    }

    public BCSnovaPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (SnovaPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSnovaPrivateKey) {
            BCSnovaPrivateKey bCSnovaPrivateKey = (BCSnovaPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCSnovaPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return Strings.toUpperCase(this.params.getParameters().getName());
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public SnovaParameterSpec getParameterSpec() {
        return SnovaParameterSpec.fromName(this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    SnovaPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

