/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.openssl.jcajce;

import amp_libs.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import amp_libs.org.bouncycastle.jcajce.util.JcaJceHelper;
import amp_libs.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import amp_libs.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import amp_libs.org.bouncycastle.openssl.PEMEncryptor;
import amp_libs.org.bouncycastle.openssl.PEMException;
import amp_libs.org.bouncycastle.openssl.jcajce.PEMUtilities;
import java.security.Provider;
import java.security.SecureRandom;

public class JcePEMEncryptorBuilder {
    private final String algorithm;
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private SecureRandom random;

    public JcePEMEncryptorBuilder(String string) {
        this.algorithm = string;
    }

    public JcePEMEncryptorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePEMEncryptorBuilder setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public JcePEMEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public PEMEncryptor build(final char[] cArray) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        int n = this.algorithm.startsWith("AES-") ? 16 : 8;
        final byte[] byArray = new byte[n];
        this.random.nextBytes(byArray);
        return new PEMEncryptor(){

            @Override
            public String getAlgorithm() {
                return JcePEMEncryptorBuilder.this.algorithm;
            }

            @Override
            public byte[] getIV() {
                return byArray;
            }

            @Override
            public byte[] encrypt(byte[] byArray2) throws PEMException {
                return PEMUtilities.crypt(true, JcePEMEncryptorBuilder.this.helper, byArray2, cArray, JcePEMEncryptorBuilder.this.algorithm, byArray);
            }
        };
    }
}

