/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.cert.cmp;

import amp_libs.org.bouncycastle.asn1.cmp.CMPCertificate;
import amp_libs.org.bouncycastle.asn1.cmp.CertStatus;
import amp_libs.org.bouncycastle.asn1.cmp.PKIStatusInfo;
import amp_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import amp_libs.org.bouncycastle.cert.X509CertificateHolder;
import amp_libs.org.bouncycastle.cert.cmp.CMPException;
import amp_libs.org.bouncycastle.cert.cmp.CMPUtil;
import amp_libs.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import amp_libs.org.bouncycastle.operator.DigestCalculatorProvider;
import amp_libs.org.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class CertificateStatus {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertStatus certStatus;

    CertificateStatus(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, CertStatus certStatus) {
        this.digestAlgFinder = digestAlgorithmIdentifierFinder;
        this.certStatus = certStatus;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.certStatus.getStatusInfo();
    }

    public BigInteger getCertRequestID() {
        return this.certStatus.getCertReqId().getValue();
    }

    public boolean isVerified(X509CertificateHolder x509CertificateHolder, DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        return this.isVerified(new CMPCertificate(x509CertificateHolder.toASN1Structure()), x509CertificateHolder.getSignatureAlgorithm(), digestCalculatorProvider);
    }

    public boolean isVerified(CMPCertificate cMPCertificate, AlgorithmIdentifier algorithmIdentifier, DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        byte[] byArray = CMPUtil.calculateCertHash(cMPCertificate, algorithmIdentifier, digestCalculatorProvider, this.digestAlgFinder);
        return Arrays.constantTimeAreEqual(this.certStatus.getCertHash().getOctets(), byArray);
    }
}

