/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.operator;

import amp_libs.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import amp_libs.org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import amp_libs.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import amp_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import amp_libs.org.bouncycastle.operator.KemEncapsulationLengthProvider;
import amp_libs.org.bouncycastle.util.Integers;
import java.util.HashMap;
import java.util.Map;

public class DefaultKemEncapsulationLengthProvider
implements KemEncapsulationLengthProvider {
    private static Map<ASN1ObjectIdentifier, Integer> kemEncapsulationLengths = new HashMap<ASN1ObjectIdentifier, Integer>();

    @Override
    public int getEncapsulationLength(AlgorithmIdentifier algorithmIdentifier) {
        return kemEncapsulationLengths.get(algorithmIdentifier.getAlgorithm());
    }

    static {
        kemEncapsulationLengths.put(NISTObjectIdentifiers.id_alg_ml_kem_512, Integers.valueOf(768));
        kemEncapsulationLengths.put(NISTObjectIdentifiers.id_alg_ml_kem_768, Integers.valueOf(1088));
        kemEncapsulationLengths.put(NISTObjectIdentifiers.id_alg_ml_kem_1024, Integers.valueOf(1568));
        kemEncapsulationLengths.put(BCObjectIdentifiers.ntruhps2048509, Integers.valueOf(699));
        kemEncapsulationLengths.put(BCObjectIdentifiers.ntruhps2048677, Integers.valueOf(930));
        kemEncapsulationLengths.put(BCObjectIdentifiers.ntruhps4096821, Integers.valueOf(1230));
        kemEncapsulationLengths.put(BCObjectIdentifiers.ntruhps40961229, Integers.valueOf(1842));
        kemEncapsulationLengths.put(BCObjectIdentifiers.ntruhrss701, Integers.valueOf(1138));
        kemEncapsulationLengths.put(BCObjectIdentifiers.ntruhrss1373, Integers.valueOf(2401));
    }
}

