/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Function;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.auth.Secrets;
import pl.skidam.automodpack_core.config.ConfigTools;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.protocol.DownloadClient;
import pl.skidam.automodpack_core.utils.AddressHelpers;
import pl.skidam.automodpack_core.utils.CustomFileUtils;
import pl.skidam.automodpack_core.utils.FileInspection;
import pl.skidam.automodpack_core.utils.ModpackContentTools;

public class ModpackUtils {
    public static boolean isUpdate(Jsons.ModpackContentFields serverModpackContent, Path modpackDir) {
        if (serverModpackContent == null || serverModpackContent.list == null) {
            throw new IllegalArgumentException("Server modpack content list is null");
        }
        Optional<Path> optionalClientModpackContentFile = ModpackContentTools.getModpackContentFile(modpackDir);
        if (optionalClientModpackContentFile.isPresent() && Files.exists(optionalClientModpackContentFile.get(), new LinkOption[0])) {
            Jsons.ModpackContentFields clientModpackContent = ConfigTools.loadModpackContent(optionalClientModpackContentFile.get());
            if (clientModpackContent == null) {
                return true;
            }
            GlobalVariables.LOGGER.info("Checking files...");
            for (Jsons.ModpackContentFields.ModpackContentItem modpackContentField : serverModpackContent.list) {
                String file = modpackContentField.file;
                String serverSHA1 = modpackContentField.sha1;
                Path path = CustomFileUtils.getPath(modpackDir, file);
                if (Files.exists(path, new LinkOption[0])) {
                    if (modpackContentField.editable) {
                        continue;
                    }
                } else {
                    Path standardPath = CustomFileUtils.getPathFromCWD(file);
                    if (Files.exists(standardPath, new LinkOption[0]) && Objects.equals(serverSHA1, CustomFileUtils.getHash(standardPath))) {
                        GlobalVariables.LOGGER.info("File {} already exists on client, coping to modpack", (Object)file);
                        try {
                            CustomFileUtils.copyFile(standardPath, path);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    GlobalVariables.LOGGER.info("File does not exists {} - {}", (Object)standardPath, (Object)file);
                    return true;
                }
                if (Objects.equals(serverSHA1, CustomFileUtils.getHash(path))) continue;
                GlobalVariables.LOGGER.info("File does not match hash {} - {}", (Object)path, (Object)file);
                return true;
            }
            for (Jsons.ModpackContentFields.ModpackContentItem modpackContentField : clientModpackContent.list) {
                Optional<Jsons.ModpackContentFields.ModpackContentItem> serverItemOpt = serverModpackContent.list.stream().filter(item -> item.file.equals(modpackContentField.file)).findFirst();
                if (!serverItemOpt.isEmpty()) continue;
                GlobalVariables.LOGGER.info("File does not exist on server {}", (Object)modpackContentField.file);
                return true;
            }
            GlobalVariables.LOGGER.info("{} is up to date!", (Object)modpackDir);
            return false;
        }
        return true;
    }

    public static boolean correctFilesLocations(Path modpackDir, Jsons.ModpackContentFields serverModpackContent, Set<String> filesNotToCopy) throws IOException {
        if (serverModpackContent == null || serverModpackContent.list == null) {
            GlobalVariables.LOGGER.error("Server modpack content list is null");
            return false;
        }
        boolean needsRestart = false;
        for (Jsons.ModpackContentFields.ModpackContentItem contentItem : serverModpackContent.list) {
            String formattedFile = contentItem.file;
            if (filesNotToCopy.contains(formattedFile)) continue;
            Path modpackFile = CustomFileUtils.getPath(modpackDir, formattedFile);
            Path runFile = CustomFileUtils.getPathFromCWD(formattedFile);
            if (contentItem.type.equals("mod")) {
                runFile = CustomFileUtils.getPath(GlobalVariables.MODS_DIR, formattedFile.replaceFirst("/mods/", ""));
            }
            boolean modpackFileExists = Files.exists(modpackFile, new LinkOption[0]);
            boolean runFileExists = Files.exists(runFile, new LinkOption[0]);
            boolean needsReCheck = true;
            if (modpackFileExists && !runFileExists) {
                if (contentItem.type.equals("mod")) {
                    needsRestart = true;
                    GlobalVariables.LOGGER.info("Applying workaround for {} mod", (Object)formattedFile);
                }
                CustomFileUtils.copyFile(modpackFile, runFile);
            } else if (!modpackFileExists && runFileExists) {
                CustomFileUtils.copyFile(runFile, modpackFile);
                needsReCheck = false;
            } else if (!modpackFileExists) {
                GlobalVariables.LOGGER.error("File {} doesn't exist!? If you see this please report this to the automodpack repo and attach this log https://github.com/Skidamek/AutoModpack/issues", (Object)formattedFile);
                Thread.dumpStack();
            }
            if (!needsReCheck || !Files.exists(runFile, new LinkOption[0]) || Objects.equals(contentItem.sha1, CustomFileUtils.getHash(runFile))) continue;
            GlobalVariables.LOGGER.info("Overwriting {} file to the modpack version", (Object)formattedFile);
            CustomFileUtils.copyFile(modpackFile, runFile);
        }
        return needsRestart;
    }

    public static boolean fixNestedMods(List<FileInspection.Mod> conflictingNestedMods, Collection<FileInspection.Mod> standardModList) throws IOException {
        if (conflictingNestedMods.isEmpty()) {
            return false;
        }
        List<String> standardModIDs = standardModList.stream().map(FileInspection.Mod::modID).toList();
        boolean needsRestart = false;
        for (FileInspection.Mod mod : conflictingNestedMods) {
            Path modPath;
            Path standardModPath;
            if (standardModIDs.stream().anyMatch(mod.providesIDs()::contains) || Objects.equals(CustomFileUtils.getHash(standardModPath = GlobalVariables.MODS_DIR.resolve((modPath = mod.modPath()).getFileName())), mod.hash())) continue;
            needsRestart = true;
            GlobalVariables.LOGGER.info("Copying nested mod {} to standard mods folder", (Object)standardModPath.getFileName());
            CustomFileUtils.copyFile(modPath, standardModPath);
            standardModList.add(FileInspection.getMod(standardModPath));
        }
        return needsRestart;
    }

    public static Set<String> getIgnoredWithNested(List<FileInspection.Mod> conflictingNestedMods, Set<String> ignoredFiles) {
        HashSet<String> newIgnoredFiles = new HashSet<String>(ignoredFiles);
        for (FileInspection.Mod mod : conflictingNestedMods) {
            newIgnoredFiles.add(CustomFileUtils.formatPath(mod.modPath(), GlobalVariables.modpacksDir));
        }
        return newIgnoredFiles;
    }

    public static Map<FileInspection.Mod, FileInspection.Mod> getDupeMods(Path modpackDir, Set<String> ignoredMods, Collection<FileInspection.Mod> standardModList, Collection<FileInspection.Mod> modpackModList) {
        if (standardModList.isEmpty() || modpackModList.isEmpty()) {
            return Map.of();
        }
        HashMap<FileInspection.Mod, FileInspection.Mod> duplicates = new HashMap<FileInspection.Mod, FileInspection.Mod>();
        for (FileInspection.Mod modpackMod : modpackModList) {
            String formattedFile;
            FileInspection.Mod standardMod = standardModList.stream().filter(mod -> mod.modID().equals(modpackMod.modID())).findFirst().orElse(null);
            if (standardMod == null || ignoredMods.contains(formattedFile = CustomFileUtils.formatPath(modpackMod.modPath(), modpackDir))) continue;
            duplicates.put(modpackMod, standardMod);
        }
        return duplicates;
    }

    public static boolean removeDupeMods(Path modpackDir, Collection<FileInspection.Mod> standardModList, Collection<FileInspection.Mod> modpackModList, Set<String> ignoredMods, Set<String> workaroundMods) throws IOException {
        Map<FileInspection.Mod, FileInspection.Mod> dupeMods = ModpackUtils.getDupeMods(modpackDir, ignoredMods, standardModList, modpackModList);
        if (dupeMods.isEmpty()) {
            return false;
        }
        HashSet<FileInspection.Mod> modsToKeep = new HashSet<FileInspection.Mod>();
        for (FileInspection.Mod standardMod : standardModList) {
            if (dupeMods.containsValue(standardMod)) continue;
            modsToKeep.add(standardMod);
            ModpackUtils.addDependenciesRecursively(standardMod, standardModList, modsToKeep);
        }
        HashSet idsToKeep = new HashSet();
        modsToKeep.forEach(mod -> {
            idsToKeep.add(mod.modID());
            idsToKeep.addAll(mod.providesIDs());
        });
        ArrayList<Path> deletedMods = new ArrayList<Path>();
        for (Map.Entry<FileInspection.Mod, FileInspection.Mod> dupeMod : dupeMods.entrySet()) {
            FileInspection.Mod modpackMod = dupeMod.getKey();
            FileInspection.Mod standardMod = dupeMod.getValue();
            Path modpackModPath = modpackMod.modPath();
            Path standardModPath = standardMod.modPath();
            String modId = modpackMod.modID();
            Collection<String> providesIDs = modpackMod.providesIDs();
            ArrayList<String> IDs = new ArrayList<String>(providesIDs);
            IDs.add(modId);
            boolean isDependent = IDs.stream().anyMatch(idsToKeep::contains);
            boolean isWorkaround = workaroundMods.contains(CustomFileUtils.formatPath(standardModPath, GlobalVariables.MODS_DIR.getParent()));
            if (isDependent) {
                if (Objects.equals(modpackMod.hash(), standardMod.hash())) continue;
                GlobalVariables.LOGGER.warn("Changing duplicated mod {} - {} to modpack version - {}", (Object)modId, (Object)standardMod.modVersion(), (Object)modpackMod.modVersion());
                CustomFileUtils.forceDelete(standardModPath);
                CustomFileUtils.copyFile(modpackModPath, standardModPath.getParent().resolve(modpackModPath.getFileName()));
                deletedMods.add(standardModPath);
                continue;
            }
            if (isWorkaround) continue;
            GlobalVariables.LOGGER.warn("Removing {} mod. It is duplicated modpack mod and no other mods are dependent on it!", (Object)modId);
            CustomFileUtils.forceDelete(standardModPath);
            deletedMods.add(standardModPath);
        }
        return !deletedMods.isEmpty();
    }

    private static void addDependenciesRecursively(FileInspection.Mod mod, Collection<FileInspection.Mod> modList, Set<FileInspection.Mod> modsToKeep) {
        for (String depId : mod.dependencies()) {
            for (FileInspection.Mod modItem : modList) {
                if (!modItem.modID().equals(depId) && !modItem.providesIDs().contains(depId) || !modsToKeep.add(modItem)) continue;
                ModpackUtils.addDependenciesRecursively(modItem, modList, modsToKeep);
            }
        }
    }

    public static Path renameModpackDir(Jsons.ModpackContentFields serverModpackContent, Path modpackDir) {
        if (GlobalVariables.clientConfig.installedModpacks == null || GlobalVariables.clientConfig.selectedModpack == null || GlobalVariables.clientConfig.selectedModpack.isBlank()) {
            return modpackDir;
        }
        String installedModpackName = GlobalVariables.clientConfig.selectedModpack;
        String installedModpackLink = GlobalVariables.clientConfig.installedModpacks.get(installedModpackName);
        InetSocketAddress installedModpackAddress = AddressHelpers.parse(installedModpackLink);
        String serverModpackName = serverModpackContent.modpackName;
        if (!serverModpackName.equals(installedModpackName) && !serverModpackName.isEmpty()) {
            Path newModpackDir = modpackDir.getParent().resolve(serverModpackName);
            try {
                Files.move(modpackDir, newModpackDir, StandardCopyOption.REPLACE_EXISTING);
                ModpackUtils.removeModpackFromList(installedModpackName);
                GlobalVariables.LOGGER.info("Changed modpack name of {} to {}", (Object)modpackDir.getFileName().toString(), (Object)serverModpackName);
            }
            catch (DirectoryNotEmptyException directoryNotEmptyException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ModpackUtils.selectModpack(newModpackDir, installedModpackAddress, Set.of());
            return newModpackDir;
        }
        return modpackDir;
    }

    public static boolean selectModpack(Path modpackDirToSelect, InetSocketAddress modpackAddressToSelect, Set<String> newDownloadedFiles) {
        Path modpackContentFile;
        Jsons.ModpackContentFields modpackContentToSelect;
        Path selectedModpackDir;
        Path selectedModpackContentFile;
        Jsons.ModpackContentFields modpackContent;
        String modpackToSelect = modpackDirToSelect.getFileName().toString();
        String selectedModpack = GlobalVariables.clientConfig.selectedModpack;
        if (selectedModpack != null && !selectedModpack.isBlank() && (modpackContent = ConfigTools.loadModpackContent(selectedModpackContentFile = (selectedModpackDir = GlobalVariables.modpacksDir.resolve(selectedModpack)).resolve(GlobalVariables.hostModpackContentFile.getFileName()))) != null) {
            Set<String> editableFiles = ModpackUtils.getEditableFiles(modpackContent.list);
            ModpackUtils.preserveEditableFiles(selectedModpackDir, editableFiles, newDownloadedFiles);
        }
        if ((modpackContentToSelect = ConfigTools.loadModpackContent(modpackContentFile = modpackDirToSelect.resolve(GlobalVariables.hostModpackContentFile.getFileName()))) != null) {
            Set<String> editableFiles = ModpackUtils.getEditableFiles(modpackContentToSelect.list);
            ModpackUtils.copyPreviousEditableFiles(modpackDirToSelect, editableFiles, newDownloadedFiles);
        }
        GlobalVariables.clientConfig.selectedModpack = modpackToSelect;
        ConfigTools.save(GlobalVariables.clientConfigFile, GlobalVariables.clientConfig);
        ModpackUtils.addModpackToList(modpackToSelect, modpackAddressToSelect);
        return !Objects.equals(modpackToSelect, selectedModpack);
    }

    public static void removeModpackFromList(String modpackName) {
        if (modpackName == null || modpackName.isEmpty()) {
            return;
        }
        if (GlobalVariables.clientConfig.installedModpacks != null && GlobalVariables.clientConfig.installedModpacks.containsKey(modpackName)) {
            HashMap<String, String> modpacks = new HashMap<String, String>(GlobalVariables.clientConfig.installedModpacks);
            modpacks.remove(modpackName);
            GlobalVariables.clientConfig.installedModpacks = modpacks;
            ConfigTools.save(GlobalVariables.clientConfigFile, GlobalVariables.clientConfig);
        }
    }

    public static void addModpackToList(String modpackName, InetSocketAddress address) {
        if (modpackName == null || modpackName.isEmpty() || address == null) {
            return;
        }
        HashMap<String, String> modpacks = new HashMap<String, String>(GlobalVariables.clientConfig.installedModpacks);
        String addressString = address.getHostString() + ":" + address.getPort();
        modpacks.put(modpackName, addressString);
        GlobalVariables.clientConfig.installedModpacks = modpacks;
        ConfigTools.save(GlobalVariables.clientConfigFile, GlobalVariables.clientConfig);
    }

    public static Path getModpackPath(InetSocketAddress address, String modpackName) {
        String strAddress = address.getHostString() + ":" + address.getPort();
        Object correctedName = strAddress;
        if (FileInspection.isInValidFileName(strAddress)) {
            correctedName = FileInspection.fixFileName(strAddress);
        }
        Path modpackDir = CustomFileUtils.getPath(GlobalVariables.modpacksDir, (String)correctedName);
        if (!modpackName.isEmpty()) {
            if (GlobalVariables.clientConfig.installedModpacks != null && GlobalVariables.clientConfig.installedModpacks.containsValue(correctedName)) {
                return modpackDir;
            }
            String nameFromName = modpackName;
            if (FileInspection.isInValidFileName(modpackName)) {
                nameFromName = FileInspection.fixFileName(modpackName);
            }
            modpackDir = CustomFileUtils.getPath(GlobalVariables.modpacksDir, nameFromName);
        }
        return modpackDir;
    }

    public static Optional<Jsons.ModpackContentFields> requestServerModpackContent(InetSocketAddress address, Secrets.Secret secret) {
        return ModpackUtils.fetchModpackContent(address, secret, client -> client.downloadFile(new byte[0], GlobalVariables.modpackContentTempFile, null), "Fetched");
    }

    public static Optional<Jsons.ModpackContentFields> refreshServerModpackContent(InetSocketAddress address, Secrets.Secret secret, byte[][] fileHashes) {
        return ModpackUtils.fetchModpackContent(address, secret, client -> client.requestRefresh(fileHashes, GlobalVariables.modpackContentTempFile), "Re-fetched");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<Jsons.ModpackContentFields> fetchModpackContent(InetSocketAddress address, Secrets.Secret secret, Function<DownloadClient, Future<Path>> operation, String fetchType) {
        if (secret == null) {
            return Optional.empty();
        }
        if (address == null) {
            throw new IllegalArgumentException("Address is null");
        }
        try (DownloadClient client = null;){
            client = new DownloadClient(address, secret, 1);
            Future<Path> future = operation.apply(client);
            Path path = future.get();
            Optional<Jsons.ModpackContentFields> content = Optional.ofNullable(ConfigTools.loadModpackContent(path));
            Files.deleteIfExists(GlobalVariables.modpackContentTempFile);
            if (content.isPresent() && ModpackUtils.potentiallyMalicious(content.get())) {
                Optional<Jsons.ModpackContentFields> optional = Optional.empty();
                return optional;
            }
            Optional<Jsons.ModpackContentFields> optional = content;
            return optional;
        }
        return Optional.empty();
    }

    public static boolean potentiallyMalicious(Jsons.ModpackContentFields serverModpackContent) {
        String modpackName = serverModpackContent.modpackName;
        if (modpackName.contains("../") || modpackName.contains("/..")) {
            GlobalVariables.LOGGER.error("Modpack content is invalid, it contains /../ in modpack name");
            return true;
        }
        for (Jsons.ModpackContentFields.ModpackContentItem modpackContentItem : serverModpackContent.list) {
            String file = modpackContentItem.file.replace("\\", "/");
            if (file.contains("../") || file.contains("/..")) {
                GlobalVariables.LOGGER.error("Modpack content is invalid, it contains /../ in file name of {}", (Object)file);
                return true;
            }
            String sha1 = modpackContentItem.sha1;
            if (sha1 != null && !sha1.equals("null")) continue;
            GlobalVariables.LOGGER.error("Modpack content is invalid, it contains null sha1 in file of {}", (Object)file);
            return true;
        }
        return false;
    }

    public static void preserveEditableFiles(Path modpackDir, Set<String> editableFiles, Set<String> newDownloadedFiles) {
        for (String file : editableFiles) {
            Path path;
            if (newDownloadedFiles.contains(file) || !Files.exists(path = CustomFileUtils.getPathFromCWD(file), new LinkOption[0])) continue;
            try {
                CustomFileUtils.copyFile(path, CustomFileUtils.getPath(modpackDir, file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void copyPreviousEditableFiles(Path modpackDir, Set<String> editableFiles, Set<String> newDownloadedFiles) {
        for (String file : editableFiles) {
            Path path;
            if (newDownloadedFiles.contains(file) || file.contains("/mods/") && file.endsWith(".jar") || !Files.exists(path = CustomFileUtils.getPath(modpackDir, file), new LinkOption[0])) continue;
            try {
                CustomFileUtils.copyFile(path, CustomFileUtils.getPathFromCWD(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static Set<String> getEditableFiles(Set<Jsons.ModpackContentFields.ModpackContentItem> modpackContentItems) {
        HashSet<String> editableFiles = new HashSet<String>();
        for (Jsons.ModpackContentFields.ModpackContentItem modpackContentItem : modpackContentItems) {
            if (!modpackContentItem.editable) continue;
            editableFiles.add(modpackContentItem.file);
        }
        return editableFiles;
    }
}

