/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol;

import am_libs.org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.protocol.CustomizableTrustManager;
import pl.skidam.automodpack_core.utils.AddressHelpers;

class PreValidationConnection {
    private final SSLSocket socket;
    private final X509Certificate unvalidatedCertificate;

    public PreValidationConnection(InetSocketAddress resolvedHostAddress, Jsons.ModpackAddresses modpackAddresses, KeyStore keyStore) throws IOException, KeyStoreException {
        Socket plainSocket = new Socket();
        plainSocket.connect(resolvedHostAddress, 15000);
        plainSocket.setSoTimeout(15000);
        DataOutputStream plainOut = new DataOutputStream(plainSocket.getOutputStream());
        DataInputStream plainIn = new DataInputStream(plainSocket.getInputStream());
        plainOut.writeInt(1095585091);
        plainOut.flush();
        int handshakeResponse = plainIn.readInt();
        if (handshakeResponse != 1095585611) {
            plainSocket.close();
            throw new IOException("Invalid handshake response from server: " + handshakeResponse);
        }
        AtomicReference interceptedCertificateChain = new AtomicReference();
        SSLContext context = this.createSSLContext(keyStore, interceptedCertificateChain::set);
        SSLSocketFactory factory = context.getSocketFactory();
        SSLSocket sslSocket = (SSLSocket)factory.createSocket(plainSocket, resolvedHostAddress.getHostString(), resolvedHostAddress.getPort(), true);
        sslSocket.setEnabledProtocols(new String[]{"TLSv1.3"});
        sslSocket.setEnabledCipherSuites(new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256"});
        SSLParameters sslParameters = new SSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        sslSocket.setSSLParameters(sslParameters);
        SSLSession session = sslSocket.getSession();
        X509Certificate certificate = null;
        X509Certificate unvalidatedCertificate = null;
        X509Certificate[] serverCertificateChain = (X509Certificate[])interceptedCertificateChain.get();
        if (serverCertificateChain != null && serverCertificateChain.length > 0) {
            certificate = serverCertificateChain[0];
        }
        if (certificate == null) {
            throw new IOException("No certificate found in server's response");
        }
        if (!session.isValid()) {
            sslSocket.close();
            unvalidatedCertificate = certificate;
        }
        if (!PreValidationConnection.isSelfSigned(certificate) && session.isValid()) {
            DefaultHostnameVerifier hostnameVerifier = new DefaultHostnameVerifier();
            String modpackHostHostName = AddressHelpers.getHostNameOrAddress(modpackAddresses.hostAddress);
            String modpackServerHostName = AddressHelpers.getHostNameOrAddress(modpackAddresses.serverAddress);
            if (!hostnameVerifier.verify(modpackHostHostName, session) || !hostnameVerifier.verify(modpackServerHostName, session)) {
                sslSocket.close();
                unvalidatedCertificate = certificate;
                GlobalVariables.LOGGER.error("Certificate validation failed: certificate doesn't match the required domains {} and {}", (Object)modpackHostHostName, (Object)modpackServerHostName);
            } else {
                GlobalVariables.LOGGER.info("Signed certificate validation succeeded for {} and {}", (Object)modpackHostHostName, (Object)modpackServerHostName);
            }
        }
        this.unvalidatedCertificate = unvalidatedCertificate;
        this.socket = sslSocket;
    }

    private static boolean isSelfSigned(X509Certificate certificate) {
        try {
            certificate.verify(certificate.getPublicKey());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            return false;
        }
        return true;
    }

    protected SSLSocket getSocket() {
        return this.socket;
    }

    public X509Certificate getUnvalidatedCertificate() {
        return this.unvalidatedCertificate;
    }

    private SSLContext createSSLContext(KeyStore trustedCertificates, Consumer<X509Certificate[]> onValidating) throws KeyStoreException {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance("TLSv1.3");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("TLS 1.3 is not supported", e);
        }
        CustomizableTrustManager trustManager = new CustomizableTrustManager(trustedCertificates, onValidating);
        try {
            sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("Failed to initialize SSLContext", e);
        }
        return sslContext;
    }
}

