/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.apache.hc.core5.http.nio.support;

import am_libs.org.apache.hc.core5.concurrent.FutureCallback;
import am_libs.org.apache.hc.core5.http.EntityDetails;
import am_libs.org.apache.hc.core5.http.Header;
import am_libs.org.apache.hc.core5.http.HttpException;
import am_libs.org.apache.hc.core5.http.HttpRequest;
import am_libs.org.apache.hc.core5.http.HttpResponse;
import am_libs.org.apache.hc.core5.http.nio.AsyncPushProducer;
import am_libs.org.apache.hc.core5.http.nio.AsyncRequestConsumer;
import am_libs.org.apache.hc.core5.http.nio.AsyncResponseProducer;
import am_libs.org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import am_libs.org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import am_libs.org.apache.hc.core5.http.nio.CapacityChannel;
import am_libs.org.apache.hc.core5.http.nio.DataStreamChannel;
import am_libs.org.apache.hc.core5.http.nio.ResponseChannel;
import am_libs.org.apache.hc.core5.http.nio.support.AsyncResponseBuilder;
import am_libs.org.apache.hc.core5.http.protocol.HttpContext;
import am_libs.org.apache.hc.core5.util.Asserts;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractServerExchangeHandler<T>
implements AsyncServerExchangeHandler {
    private final AtomicReference<AsyncRequestConsumer<T>> requestConsumerRef = new AtomicReference();
    private final AtomicReference<AsyncResponseProducer> responseProducerRef = new AtomicReference();

    protected abstract AsyncRequestConsumer<T> supplyConsumer(HttpRequest var1, EntityDetails var2, HttpContext var3) throws HttpException;

    protected abstract void handle(T var1, AsyncServerRequestHandler.ResponseTrigger var2, HttpContext var3) throws HttpException, IOException;

    @Override
    public final void handleRequest(HttpRequest request, EntityDetails entityDetails, final ResponseChannel responseChannel, final HttpContext context) throws HttpException, IOException {
        AsyncRequestConsumer<T> requestConsumer = this.supplyConsumer(request, entityDetails, context);
        if (requestConsumer == null) {
            throw new HttpException("Unable to handle request");
        }
        this.requestConsumerRef.set(requestConsumer);
        final AsyncServerRequestHandler.ResponseTrigger responseTrigger = new AsyncServerRequestHandler.ResponseTrigger(){

            @Override
            public void sendInformation(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
                responseChannel.sendInformation(response, httpContext);
            }

            @Override
            public void submitResponse(AsyncResponseProducer producer, HttpContext httpContext) throws HttpException, IOException {
                if (AbstractServerExchangeHandler.this.responseProducerRef.compareAndSet(null, producer)) {
                    producer.sendResponse(responseChannel, httpContext);
                }
            }

            @Override
            public void pushPromise(HttpRequest promise, HttpContext httpContext, AsyncPushProducer pushProducer) throws HttpException, IOException {
                responseChannel.pushPromise(promise, pushProducer, httpContext);
            }

            public String toString() {
                return "Response trigger: " + responseChannel;
            }
        };
        requestConsumer.consumeRequest(request, entityDetails, context, new FutureCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(T result) {
                try {
                    AbstractServerExchangeHandler.this.handle(result, responseTrigger, context);
                }
                catch (HttpException ex) {
                    try {
                        responseTrigger.submitResponse(AsyncResponseBuilder.create(500).setEntity(ex.getMessage()).build(), context);
                    }
                    catch (HttpException | IOException ex2) {
                        AbstractServerExchangeHandler.this.failedInternal(ex2);
                    }
                }
                catch (IOException ex) {
                    AbstractServerExchangeHandler.this.failedInternal(ex);
                }
                finally {
                    AbstractServerExchangeHandler.this.releaseRequestConsumer();
                }
            }

            @Override
            public void failed(Exception ex) {
                AbstractServerExchangeHandler.this.failedInternal(ex);
            }

            @Override
            public void cancelled() {
                AbstractServerExchangeHandler.this.releaseResourcesInternal();
            }
        });
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        AsyncRequestConsumer<T> requestConsumer = this.requestConsumerRef.get();
        Asserts.notNull(requestConsumer, "Data consumer");
        requestConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public final void consume(ByteBuffer src) throws IOException {
        AsyncRequestConsumer<T> requestConsumer = this.requestConsumerRef.get();
        Asserts.notNull(requestConsumer, "Data consumer");
        requestConsumer.consume(src);
    }

    @Override
    public final void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        AsyncRequestConsumer<T> requestConsumer = this.requestConsumerRef.get();
        Asserts.notNull(requestConsumer, "Data consumer");
        requestConsumer.streamEnd(trailers);
    }

    @Override
    public final int available() {
        AsyncResponseProducer dataProducer = this.responseProducerRef.get();
        return dataProducer != null ? dataProducer.available() : 0;
    }

    @Override
    public final void produce(DataStreamChannel channel) throws IOException {
        AsyncResponseProducer dataProducer = this.responseProducerRef.get();
        Asserts.notNull(dataProducer, "Data producer");
        dataProducer.produce(channel);
    }

    @Override
    public final void failed(Exception cause) {
        this.failedInternal(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failedInternal(Exception cause) {
        try {
            AsyncRequestConsumer<T> requestConsumer = this.requestConsumerRef.get();
            if (requestConsumer != null) {
                requestConsumer.failed(cause);
            }
        }
        finally {
            this.releaseRequestConsumer();
        }
        try {
            AsyncResponseProducer dataProducer = this.responseProducerRef.get();
            if (dataProducer != null) {
                dataProducer.failed(cause);
            }
        }
        finally {
            this.releaseResponseProducer();
        }
    }

    private void releaseRequestConsumer() {
        AsyncRequestConsumer requestConsumer = this.requestConsumerRef.getAndSet(null);
        if (requestConsumer != null) {
            requestConsumer.releaseResources();
        }
    }

    private void releaseResponseProducer() {
        AsyncResponseProducer dataProducer = this.responseProducerRef.getAndSet(null);
        if (dataProducer != null) {
            dataProducer.releaseResources();
        }
    }

    private void releaseResourcesInternal() {
        this.releaseResponseProducer();
        this.releaseRequestConsumer();
    }

    @Override
    public final void releaseResources() {
        this.releaseResponseProducer();
    }
}

