/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.apache.hc.core5.http.support;

import amp_libs.org.apache.hc.core5.annotation.Internal;
import amp_libs.org.apache.hc.core5.http.EntityDetails;
import amp_libs.org.apache.hc.core5.http.HttpRequest;
import amp_libs.org.apache.hc.core5.http.HttpVersion;
import amp_libs.org.apache.hc.core5.http.ProtocolException;
import amp_libs.org.apache.hc.core5.http.message.MessageSupport;
import amp_libs.org.apache.hc.core5.http.support.Expectation;
import amp_libs.org.apache.hc.core5.util.TextUtils;
import java.util.concurrent.atomic.AtomicReference;

@Internal
public class ExpectSupport {
    public static Expectation parse(HttpRequest request, EntityDetails entityDetails) throws ProtocolException {
        if (request.getVersion() != null && request.getVersion().lessEquals(HttpVersion.HTTP_1_0)) {
            return null;
        }
        AtomicReference expectationRef = new AtomicReference();
        MessageSupport.parseTokens(request, "Expect", t2 -> {
            if (t2.equalsIgnoreCase("100-continue")) {
                expectationRef.compareAndSet(null, Expectation.CONTINUE);
            } else if (!TextUtils.isBlank(t2)) {
                expectationRef.set(Expectation.UNKNOWN);
            }
        });
        Expectation expectation = (Expectation)((Object)expectationRef.get());
        if (expectation == Expectation.CONTINUE && entityDetails == null) {
            throw new ProtocolException("Expect-Continue request without an enclosed entity");
        }
        return expectation;
    }
}

