/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core;

import com.google.common.collect.ImmutableMap;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileDependencyLocator;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LazyModLocator
extends AbstractJarFileDependencyLocator {
    public static Logger LOGGER = LogManager.getLogger((String)"AutoModpack/BootStrap");

    public List<IModFile> scanMods(Iterable<IModFile> loadedMods) {
        ArrayList<IModFile> list = new ArrayList<IModFile>(1);
        try {
            list.add(this.getMainMod());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public String name() {
        return null;
    }

    public void initArguments(Map<String, ?> arguments) {
    }

    private IModFile getMainMod() throws IOException, URISyntaxException {
        Path SELF_PATH = (Path)LamdbaExceptionUtils.uncheck(() -> {
            URL jarLocation = LazyModLocator.class.getProtectionDomain().getCodeSource().getLocation();
            return Path.of(jarLocation.toURI());
        });
        String depName = "META-INF/jarjar/automodpack-mod.jar";
        Path pathInModFile = SELF_PATH.resolve("META-INF/jarjar/automodpack-mod.jar");
        URI filePathUri = new URI("jij:" + pathInModFile.toAbsolutePath().toUri().getRawSchemeSpecificPart()).normalize();
        ImmutableMap outerFsArgs = ImmutableMap.of((Object)"packagePath", (Object)pathInModFile);
        FileSystem zipFS = FileSystems.newFileSystem(filePathUri, outerFsArgs);
        Path modPath = zipFS.getPath("/", new String[0]);
        IModLocator.ModFileOrException mod = this.createMod(new Path[]{modPath});
        return mod.file();
    }
}

