/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.cms.jcajce;

import amp_libs.org.bouncycastle.asn1.ASN1Encodable;
import amp_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import amp_libs.org.bouncycastle.cms.CMSException;
import amp_libs.org.bouncycastle.cms.jcajce.CMSUtils;
import amp_libs.org.bouncycastle.cms.jcajce.DefaultJcaJceExtHelper;
import amp_libs.org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import amp_libs.org.bouncycastle.cms.jcajce.NamedJcaJceExtHelper;
import amp_libs.org.bouncycastle.cms.jcajce.ProviderJcaJceExtHelper;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;

public class JceAlgorithmIdentifierConverter {
    private EnvelopedDataHelper helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
    private SecureRandom random;

    public JceAlgorithmIdentifierConverter setProvider(Provider provider) {
        this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceAlgorithmIdentifierConverter setProvider(String string) {
        this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(string));
        return this;
    }

    public AlgorithmParameters getAlgorithmParameters(AlgorithmIdentifier algorithmIdentifier) throws CMSException {
        ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
        if (aSN1Encodable == null) {
            return null;
        }
        try {
            AlgorithmParameters algorithmParameters = this.helper.createAlgorithmParameters(algorithmIdentifier.getAlgorithm());
            CMSUtils.loadParameters(algorithmParameters, algorithmIdentifier.getParameters());
            return algorithmParameters;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find parameters for algorithm", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CMSException("can't find provider for algorithm", noSuchProviderException);
        }
    }
}

