/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.its;

import amp_libs.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import amp_libs.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import amp_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import amp_libs.org.bouncycastle.its.ITSCertificate;
import amp_libs.org.bouncycastle.its.ITSCertificateBuilder;
import amp_libs.org.bouncycastle.oer.its.ieee1609dot2.CertificateBase;
import amp_libs.org.bouncycastle.oer.its.ieee1609dot2.CertificateId;
import amp_libs.org.bouncycastle.oer.its.ieee1609dot2.CertificateType;
import amp_libs.org.bouncycastle.oer.its.ieee1609dot2.IssuerIdentifier;
import amp_libs.org.bouncycastle.oer.its.ieee1609dot2.ToBeSignedCertificate;
import amp_libs.org.bouncycastle.oer.its.ieee1609dot2.VerificationKeyIndicator;
import amp_libs.org.bouncycastle.oer.its.ieee1609dot2.basetypes.EccP256CurvePoint;
import amp_libs.org.bouncycastle.oer.its.ieee1609dot2.basetypes.HashedId8;
import amp_libs.org.bouncycastle.oer.its.ieee1609dot2.basetypes.PublicEncryptionKey;
import amp_libs.org.bouncycastle.operator.DigestCalculator;
import amp_libs.org.bouncycastle.operator.DigestCalculatorProvider;
import amp_libs.org.bouncycastle.operator.OperatorCreationException;
import amp_libs.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class ITSImplicitCertificateBuilder
extends ITSCertificateBuilder {
    private final IssuerIdentifier issuerIdentifier;

    public ITSImplicitCertificateBuilder(ITSCertificate iTSCertificate, DigestCalculatorProvider digestCalculatorProvider, ToBeSignedCertificate.Builder builder) {
        super(iTSCertificate, builder);
        Object object;
        DigestCalculator digestCalculator;
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        try {
            digestCalculator = digestCalculatorProvider.get(algorithmIdentifier);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new IllegalStateException(operatorCreationException.getMessage(), operatorCreationException);
        }
        try {
            object = digestCalculator.getOutputStream();
            ((OutputStream)object).write(iTSCertificate.getEncoded());
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage(), iOException);
        }
        object = digestCalculator.getDigest();
        HashedId8 hashedId8 = new HashedId8(Arrays.copyOfRange((byte[])object, ((Object)object).length - 8, ((Object)object).length));
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha256)) {
            this.issuerIdentifier = IssuerIdentifier.sha256AndDigest(hashedId8);
        } else if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha384)) {
            this.issuerIdentifier = IssuerIdentifier.sha384AndDigest(hashedId8);
        } else {
            throw new IllegalStateException("unknown digest");
        }
    }

    public ITSCertificate build(CertificateId certificateId, BigInteger bigInteger, BigInteger bigInteger2) {
        return this.build(certificateId, bigInteger, bigInteger2, null);
    }

    public ITSCertificate build(CertificateId certificateId, BigInteger bigInteger, BigInteger bigInteger2, PublicEncryptionKey publicEncryptionKey) {
        EccP256CurvePoint eccP256CurvePoint = EccP256CurvePoint.uncompressedP256(bigInteger, bigInteger2);
        ToBeSignedCertificate.Builder builder = new ToBeSignedCertificate.Builder(this.tbsCertificateBuilder);
        builder.setId(certificateId);
        if (publicEncryptionKey != null) {
            builder.setEncryptionKey(publicEncryptionKey);
        }
        builder.setVerifyKeyIndicator(VerificationKeyIndicator.reconstructionValue(eccP256CurvePoint));
        CertificateBase.Builder builder2 = new CertificateBase.Builder();
        builder2.setVersion(this.version);
        builder2.setType(CertificateType.implicit);
        builder2.setIssuer(this.issuerIdentifier);
        builder2.setToBeSigned(builder.createToBeSignedCertificate());
        return new ITSCertificate(builder2.createCertificateBase());
    }
}

