/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.cert.crmf;

import am_libs.org.bouncycastle.asn1.cms.EnvelopedData;
import am_libs.org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import am_libs.org.bouncycastle.asn1.crmf.EncKeyWithID;
import am_libs.org.bouncycastle.asn1.crmf.EncryptedKey;
import am_libs.org.bouncycastle.asn1.crmf.PKIArchiveOptions;
import am_libs.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import am_libs.org.bouncycastle.asn1.x509.GeneralName;
import am_libs.org.bouncycastle.cert.crmf.PKIArchiveControl;
import am_libs.org.bouncycastle.cms.CMSEnvelopedData;
import am_libs.org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import am_libs.org.bouncycastle.cms.CMSException;
import am_libs.org.bouncycastle.cms.CMSProcessableByteArray;
import am_libs.org.bouncycastle.cms.RecipientInfoGenerator;
import am_libs.org.bouncycastle.operator.OutputEncryptor;
import java.io.IOException;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientInfoGenerator) {
        this.envGen.addRecipientInfoGenerator(recipientInfoGenerator);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor outputEncryptor) throws CMSException {
        CMSEnvelopedData cMSEnvelopedData = this.envGen.generate(this.keyContent, outputEncryptor);
        EnvelopedData envelopedData = EnvelopedData.getInstance(cMSEnvelopedData.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envelopedData)));
    }
}

