/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.utils.AddressHelpers;

public class ConfigTools {
    public static Gson GSON = new GsonBuilder().serializeNulls().disableHtmlEscaping().setPrettyPrinting().registerTypeAdapter(InetSocketAddress.class, (Object)new InetSocketAddressTypeAdapter()).create();

    public static <T> T getConfigObject(Class<T> configClass) {
        T object = null;
        try {
            object = configClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }

    public static <T> T loadCheck(Path configFile, Class<T> configClass) {
        try {
            if (Files.isRegularFile(configFile, new LinkOption[0])) {
                String json = Files.readString(configFile);
                Object obj = GSON.fromJson(json, configClass);
                if (obj == null) {
                    GlobalVariables.LOGGER.error("Parsed object is null. Possible JSON syntax error in file: " + String.valueOf(configFile));
                    return null;
                }
                return (T)obj;
            }
        }
        catch (JsonSyntaxException e) {
            GlobalVariables.LOGGER.error("JSON syntax error while loading config! {} {}", configClass, (Object)e.getMessage());
            GlobalVariables.LOGGER.error("This error most often happens when you e.g. forget to put a comma between fields in JSON file. Check the file: " + String.valueOf(configFile.toAbsolutePath().normalize()));
            return null;
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Couldn't load config! " + String.valueOf(configClass));
            e.printStackTrace();
        }
        return null;
    }

    public static <T> T load(Path configFile, Class<T> configClass) {
        try {
            if (!Files.isDirectory(configFile.getParent(), new LinkOption[0])) {
                Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            }
            if (Files.isRegularFile(configFile, new LinkOption[0])) {
                String json = Files.readString(configFile);
                Object obj = GSON.fromJson(json, configClass);
                if (obj == null) {
                    GlobalVariables.LOGGER.error("Parsed object is null. Possible JSON syntax error in file: " + String.valueOf(configFile));
                    return null;
                }
                ConfigTools.save(configFile, obj);
                return (T)obj;
            }
        }
        catch (JsonSyntaxException e) {
            GlobalVariables.LOGGER.error("JSON syntax error while loading config! {} {}", configClass, (Object)e.getMessage());
            GlobalVariables.LOGGER.error("This error most often happens when you e.g. forget to put a comma between fields in JSON file. Check the file: " + String.valueOf(configFile.toAbsolutePath().normalize()));
            return null;
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Couldn't load config! " + String.valueOf(configClass));
            e.printStackTrace();
        }
        try {
            T obj = ConfigTools.getConfigObject(configClass);
            ConfigTools.save(configFile, obj);
            return obj;
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Invalid config class! " + String.valueOf(configClass));
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T load(String json, Class<T> configClass) {
        try {
            if (json != null) {
                return (T)GSON.fromJson(json, configClass);
            }
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Couldn't load config! " + String.valueOf(configClass));
            e.printStackTrace();
        }
        return null;
    }

    public static void save(Path configFile, Object configObject) {
        if (GlobalVariables.clientConfigOverride != null) {
            return;
        }
        try {
            if (!Files.isDirectory(configFile.getParent(), new LinkOption[0])) {
                Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            }
            Files.writeString(configFile, (CharSequence)GSON.toJson(configObject), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Couldn't save config! " + String.valueOf(configObject.getClass()));
            e.printStackTrace();
        }
    }

    public static Jsons.ModpackContentFields loadModpackContent(Path modpackContentFile) {
        try {
            if (Files.isRegularFile(modpackContentFile, new LinkOption[0])) {
                String json = Files.readString(modpackContentFile);
                return (Jsons.ModpackContentFields)GSON.fromJson(json, Jsons.ModpackContentFields.class);
            }
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Couldn't load modpack content! {}", (Object)modpackContentFile.toAbsolutePath().normalize(), (Object)e);
        }
        return null;
    }

    public static void saveModpackContent(Path modpackContentFile, Jsons.ModpackContentFields configObject) {
        try {
            if (!Files.isDirectory(modpackContentFile.getParent(), new LinkOption[0])) {
                Files.createDirectories(modpackContentFile.getParent(), new FileAttribute[0]);
            }
            Files.writeString(modpackContentFile, (CharSequence)GSON.toJson((Object)configObject), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Couldn't save modpack content! " + String.valueOf(configObject.getClass()));
            e.printStackTrace();
        }
    }

    private static class InetSocketAddressTypeAdapter
    implements JsonSerializer<InetSocketAddress>,
    JsonDeserializer<InetSocketAddress> {
        private InetSocketAddressTypeAdapter() {
        }

        public JsonElement serialize(InetSocketAddress src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.getHostString() + ":" + src.getPort());
        }

        public InetSocketAddress deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String address = json.getAsString();
            return AddressHelpers.parse(address);
        }
    }
}

