/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.auth;

import java.net.SocketAddress;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Map;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.auth.SecretsStore;
import pl.skidam.automodpack_core.protocol.NetUtils;

public class Secrets {
    public static Secret generateSecret() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        String secret = Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
        String fingerprint = Secrets.generateFingerprint(secret);
        if (secret == null || fingerprint == null) {
            return null;
        }
        long timestamp = System.currentTimeMillis() / 1000L;
        return new Secret(secret, fingerprint, timestamp);
    }

    private static String generateFingerprint(String secret) {
        try {
            X509Certificate cert = GlobalVariables.hostServer.getCert();
            if (cert == null) {
                return null;
            }
            return NetUtils.getFingerprint(cert, secret);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isSecretValid(String secretStr, SocketAddress address) {
        boolean valid;
        if (!GlobalVariables.serverConfig.validateSecrets) {
            return true;
        }
        Map.Entry<String, Secret> playerSecretPair = SecretsStore.getHostSecret(secretStr);
        if (playerSecretPair == null) {
            return false;
        }
        Secret secret = playerSecretPair.getValue();
        if (secret == null) {
            return false;
        }
        String playerUuid = playerSecretPair.getKey();
        if (!GlobalVariables.GAME_CALL.isPlayerAuthorized(address, playerUuid)) {
            return false;
        }
        long secretLifetime = GlobalVariables.serverConfig.secretLifetime * 3600L;
        long currentTime = System.currentTimeMillis() / 1000L;
        boolean bl = valid = secret.timestamp() + secretLifetime > currentTime;
        return valid;
    }

    public static class Secret {
        private String secret;
        private String fingerprint;
        private Long timestamp;

        public Secret(String secret, String fingerprint, Long timestamp) {
            this.secret = secret;
            this.fingerprint = fingerprint;
            this.timestamp = timestamp;
        }

        public String secret() {
            return this.secret;
        }

        public String fingerprint() {
            return this.fingerprint;
        }

        public Long timestamp() {
            return this.timestamp;
        }

        public String toString() {
            return "Secret{secret='" + this.secret + "', fingerprint='" + this.fingerprint + "', timestamp=" + this.timestamp + "}";
        }
    }
}

