/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntConsumer;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.protocol.PreValidationConnection;
import pl.skidam.automodpack_core.protocol.compression.CompressionCodec;
import pl.skidam.automodpack_core.protocol.compression.CompressionFactory;

class Connection
implements AutoCloseable {
    private final byte protocolVersion;
    private final byte compressionType;
    private CompressionCodec compressionCodec;
    private final byte[] secretBytes;
    private final SSLSocket socket;
    private final DataInputStream in;
    private final DataOutputStream out;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final AtomicBoolean busy = new AtomicBoolean(false);

    public boolean isActive() {
        return !this.socket.isClosed();
    }

    public Connection(PreValidationConnection preValidationConnection, byte[] secretBytes) throws IOException {
        if (preValidationConnection.getSocket() == null || preValidationConnection.getSocket().isClosed()) {
            throw new SSLHandshakeException("Server certificate is not valid, connection got closed");
        }
        this.socket = preValidationConnection.getSocket();
        this.protocolVersion = preValidationConnection.getNegotiatedProtocolVersion();
        this.compressionType = preValidationConnection.getNegotiatedCompressionType();
        this.compressionCodec = null;
        this.secretBytes = secretBytes;
        try {
            this.in = new DataInputStream(this.socket.getInputStream());
            this.out = new DataOutputStream(this.socket.getOutputStream());
            GlobalVariables.LOGGER.debug("Connection established with: {} using protocol v{} with {} compression", (Object)this.socket.getInetAddress().getHostAddress(), (Object)this.protocolVersion, (Object)this.compressionType);
        }
        catch (IOException e) {
            throw new IOException("Failed to establish connection", e);
        }
    }

    public boolean isBusy() {
        return this.busy.get();
    }

    public void setBusy(boolean value) {
        this.busy.set(value);
    }

    private CompressionCodec getCodec() {
        if (this.compressionCodec == null) {
            this.compressionCodec = CompressionFactory.getCodec(this.compressionType);
        }
        return this.compressionCodec;
    }

    public CompletableFuture<Path> sendDownloadFile(byte[] fileHash, Path destination, IntConsumer chunkCallback) {
        if (destination == null) {
            throw new IllegalArgumentException("Destination cannot be null");
        }
        return CompletableFuture.supplyAsync(() -> {
            Exception exception = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeByte(this.protocolVersion);
                dos.writeByte(1);
                dos.write(this.secretBytes);
                dos.writeInt(fileHash.length);
                dos.write(fileHash);
                dos.flush();
                byte[] payload = baos.toByteArray();
                this.writeProtocolMessage(payload);
                Path path = this.readFileResponse(destination, chunkCallback);
                return path;
            }
            catch (Exception e) {
                exception = e;
                throw new CompletionException(e);
            }
            finally {
                this.finalBlock(exception);
            }
        }, this.executor);
    }

    public CompletableFuture<Path> sendRefreshRequest(byte[][] fileHashes, Path destination) {
        return CompletableFuture.supplyAsync(() -> {
            Exception exception = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeByte(this.protocolVersion);
                dos.writeByte(3);
                dos.write(this.secretBytes);
                dos.writeInt(fileHashes.length);
                if (fileHashes.length > 0) {
                    dos.writeInt(fileHashes[0].length);
                    for (byte[] hash : fileHashes) {
                        dos.write(hash);
                    }
                }
                dos.flush();
                byte[] payload = baos.toByteArray();
                this.writeProtocolMessage(payload);
                Path path = this.readFileResponse(destination, null);
                return path;
            }
            catch (Exception e) {
                exception = e;
                throw new CompletionException(e);
            }
            finally {
                this.finalBlock(exception);
            }
        }, this.executor);
    }

    private void finalBlock(Exception exception) {
        try {
            while (this.in.available() > 0) {
                this.in.skipBytes(this.in.available());
            }
        }
        catch (IOException e) {
            if (exception == null) {
                exception = e;
                throw new CompletionException(e);
            }
        }
        finally {
            if (exception == null) {
                this.setBusy(false);
            }
        }
    }

    private void writeProtocolMessage(byte[] payload) throws IOException {
        int bytesToSend;
        for (int offset = 0; offset < payload.length; offset += bytesToSend) {
            bytesToSend = Math.min(payload.length - offset, 131072);
            byte[] chunk = new byte[bytesToSend];
            System.arraycopy(payload, offset, chunk, 0, bytesToSend);
            byte[] compressedChunk = this.getCodec().compress(chunk);
            this.out.writeInt(compressedChunk.length);
            this.out.writeInt(chunk.length);
            this.out.write(compressedChunk);
        }
        this.out.flush();
    }

    private byte[] readProtocolMessageFrame() throws IOException {
        int compressedLength = this.in.readInt();
        int originalLength = this.in.readInt();
        if (compressedLength < 0 || originalLength < 0) {
            throw new IllegalArgumentException("Invalid compressed or original length");
        }
        if (originalLength > 131072) {
            throw new IllegalArgumentException("Original length exceeds maximum packet size");
        }
        byte[] compressed = new byte[compressedLength];
        this.in.readFully(compressed);
        return this.getCodec().decompress(compressed, originalLength);
    }

    private Path readFileResponse(Path destination, IntConsumer chunkCallback) throws IOException {
        byte[] headerFrame = this.readProtocolMessageFrame();
        try (DataInputStream headerIn = new DataInputStream(new ByteArrayInputStream(headerFrame));){
            int toWrite;
            byte version = headerIn.readByte();
            byte messageType = headerIn.readByte();
            if (messageType == 5) {
                int errLen = headerIn.readInt();
                byte[] errBytes = new byte[errLen];
                headerIn.readFully(errBytes);
                throw new IOException("Server error: " + new String(errBytes));
            }
            FileOutputStream fos = new FileOutputStream(destination.toFile());
            if (messageType == 4) {
                ((OutputStream)fos).close();
                Path path = destination;
                return path;
            }
            if (messageType != 2) {
                ((OutputStream)fos).close();
                throw new IOException("Unexpected message type: " + messageType);
            }
            long expectedFileSize = headerIn.readLong();
            for (long receivedBytes = 0L; receivedBytes < expectedFileSize; receivedBytes += (long)toWrite) {
                byte[] dataFrame = this.readProtocolMessageFrame();
                toWrite = Math.min(dataFrame.length, (int)(expectedFileSize - receivedBytes));
                ((OutputStream)fos).write(dataFrame, 0, toWrite);
                if (chunkCallback == null) continue;
                chunkCallback.accept(toWrite);
            }
            ((OutputStream)fos).close();
            byte[] eotFrame = this.readProtocolMessageFrame();
            try (DataInputStream eotIn = new DataInputStream(new ByteArrayInputStream(eotFrame));){
                byte ver = eotIn.readByte();
                byte eotType = eotIn.readByte();
                if (ver != version || eotType != 4) {
                    throw new IOException("Invalid end-of-transmission marker. Expected version " + version + " and type 4, got version " + ver + " and type " + eotType);
                }
            }
            Path path = destination;
            return path;
        }
    }

    @Override
    public void close() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executor.shutdownNow();
    }
}

