/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import pl.skidam.automodpack_core.protocol.compression.CompressionCodec;

public class CompressionDecoder
extends ByteToMessageDecoder {
    private final CompressionCodec codec;

    public CompressionDecoder(CompressionCodec codec) {
        if (codec == null) {
            throw new IllegalArgumentException("Compression codec cannot be null");
        }
        this.codec = codec;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 8) {
            return;
        }
        in.markReaderIndex();
        int compressedLength = in.readInt();
        int originalLength = in.readInt();
        if (compressedLength < 0 || originalLength < 0) {
            throw new IllegalArgumentException("Invalid compressed or original length");
        }
        if (originalLength > 131072) {
            throw new IllegalArgumentException("Original length exceeds maximum packet size");
        }
        if (in.readableBytes() < compressedLength) {
            in.resetReaderIndex();
            return;
        }
        byte[] compressed = new byte[compressedLength];
        in.readBytes(compressed);
        byte[] decompressed = this.codec.decompress(compressed, originalLength);
        ByteBuf decompressedBuf = ctx.alloc().buffer(originalLength);
        decompressedBuf.writeBytes(decompressed);
        out.add(decompressedBuf);
    }

    public CompressionCodec getCodec() {
        return this.codec;
    }
}

