/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core;

import com.google.common.collect.ImmutableMap;
import cpw.mods.modlauncher.api.LambdaExceptionUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IncompatibleFileReporting;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;

public class LazyModLocator
implements IModFileCandidateLocator {
    private Path getMainMod() throws IOException, URISyntaxException {
        Path SELF_PATH = (Path)LambdaExceptionUtils.uncheck(() -> {
            URL jarLocation = LazyModLocator.class.getProtectionDomain().getCodeSource().getLocation();
            return Path.of(jarLocation.toURI());
        });
        String depName = "automodpack-mod.jar";
        Path pathInModFile = SELF_PATH.resolve("automodpack-mod.jar");
        URI filePathUri = new URI("jij:" + pathInModFile.toAbsolutePath().toUri().getRawSchemeSpecificPart()).normalize();
        ImmutableMap outerFsArgs = ImmutableMap.of((Object)"packagePath", (Object)pathInModFile);
        FileSystem zipFS = FileSystems.newFileSystem(filePathUri, outerFsArgs);
        return zipFS.getPath("/", new String[0]);
    }

    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        try {
            Path modPath = this.getMainMod();
            pipeline.addPath(modPath, ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.ERROR);
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public int getPriority() {
        return -1000;
    }
}

