/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.auth.Secrets;
import pl.skidam.automodpack_core.auth.SecretsStore;
import pl.skidam.automodpack_core.config.ConfigTools;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.protocol.DownloadClient;
import pl.skidam.automodpack_core.utils.CustomFileUtils;
import pl.skidam.automodpack_core.utils.FileInspection;
import pl.skidam.automodpack_core.utils.MmcPackMagic;
import pl.skidam.automodpack_core.utils.WorkaroundUtil;
import pl.skidam.automodpack_loader_core.ReLauncher;
import pl.skidam.automodpack_loader_core.client.Changelogs;
import pl.skidam.automodpack_loader_core.client.ModpackUtils;
import pl.skidam.automodpack_loader_core.screen.ScreenManager;
import pl.skidam.automodpack_loader_core.utils.DownloadManager;
import pl.skidam.automodpack_loader_core.utils.FetchManager;
import pl.skidam.automodpack_loader_core.utils.UpdateType;

public class ModpackUpdater {
    public Changelogs changelogs = new Changelogs();
    public DownloadManager downloadManager;
    public FetchManager fetchManager;
    public long totalBytesToDownload = 0L;
    public boolean fullDownload = false;
    private Jsons.ModpackContentFields serverModpackContent;
    private String modpackContentJson;
    public Map<Jsons.ModpackContentFields.ModpackContentItem, List<String>> failedDownloads = new HashMap<Jsons.ModpackContentFields.ModpackContentItem, List<String>>();
    private final Set<String> newDownloadedFiles = new HashSet<String>();
    private Jsons.ModpackAddresses modpackAddresses;
    private Secrets.Secret modpackSecret;
    private Path modpackDir;
    private Path modpackContentFile;

    public String getModpackName() {
        return this.serverModpackContent.modpackName;
    }

    public void prepareUpdate(Jsons.ModpackContentFields modpackContent, Jsons.ModpackAddresses modpackAddresses, Secrets.Secret secret, Path modpackPath) {
        this.serverModpackContent = modpackContent;
        this.modpackAddresses = modpackAddresses;
        this.modpackSecret = secret;
        this.modpackDir = modpackPath;
        if (this.modpackAddresses.isAnyEmpty() || modpackPath.toString().isEmpty()) {
            throw new IllegalArgumentException("Address or modpackPath is null or empty");
        }
        try {
            this.modpackContentFile = this.modpackDir.resolve(GlobalVariables.hostModpackContentFile.getFileName());
            if (this.serverModpackContent == null) {
                this.CheckAndLoadModpack();
                return;
            }
            this.modpackContentJson = ConfigTools.GSON.toJson((Object)this.serverModpackContent);
            if (!Files.exists(this.modpackDir, new LinkOption[0])) {
                Files.createDirectories(this.modpackDir, new FileAttribute[0]);
            }
            if (Files.exists(this.modpackContentFile, new LinkOption[0])) {
                this.modpackDir = ModpackUtils.renameModpackDir(this.serverModpackContent, this.modpackDir);
                this.modpackContentFile = this.modpackDir.resolve(this.modpackContentFile.getFileName());
                if (!ModpackUtils.isUpdate(this.serverModpackContent, this.modpackDir)) {
                    GlobalVariables.LOGGER.info("Modpack is up to date");
                    Files.writeString(this.modpackContentFile, (CharSequence)this.modpackContentJson, new OpenOption[0]);
                    this.CheckAndLoadModpack();
                    return;
                }
            } else if (!GlobalVariables.preload.booleanValue()) {
                this.fullDownload = true;
                new ScreenManager().danger(new ScreenManager().getScreen().orElseThrow(), this);
                return;
            }
            GlobalVariables.LOGGER.warn("Modpack update found");
            this.startUpdate();
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Error while initializing modpack updater", (Throwable)e);
        }
    }

    public void CheckAndLoadModpack() throws Exception {
        if (!Files.exists(this.modpackDir, new LinkOption[0])) {
            return;
        }
        boolean requiresRestart = this.applyModpack();
        if (requiresRestart) {
            GlobalVariables.LOGGER.info("Modpack is not loaded");
            UpdateType updateType = this.fullDownload ? UpdateType.FULL : UpdateType.UPDATE;
            new ReLauncher(this.modpackDir, updateType, this.changelogs).restart(true, new Runnable[0]);
            return;
        }
        if (GlobalVariables.preload.booleanValue()) {
            List<String> standardModsHashes;
            List<Path> modpackMods = List.of();
            try (Stream<Path> standardModsStream = Files.list(GlobalVariables.MODS_DIR);){
                standardModsHashes = standardModsStream.map(CustomFileUtils::getHash).filter(Objects::nonNull).toList();
            }
            Path modpackModsDir = this.modpackDir.resolve("mods");
            if (Files.exists(modpackModsDir, new LinkOption[0])) {
                try (Stream<Path> modpackModsStream = Files.list(modpackModsDir);){
                    modpackMods = modpackModsStream.filter(mod -> {
                        String modHash = CustomFileUtils.getHash(mod);
                        boolean isUnique = standardModsHashes.stream().noneMatch(hash -> hash.equals(modHash));
                        boolean endsWithJar = mod.toString().endsWith(".jar");
                        boolean isFile = mod.toFile().isFile();
                        return isUnique && endsWithJar && isFile;
                    }).toList();
                }
            }
            GlobalVariables.MODPACK_LOADER.loadModpack(modpackMods);
            return;
        }
        GlobalVariables.LOGGER.info("Modpack is already loaded");
    }

    public void startUpdate() {
        if (this.modpackSecret == null) {
            GlobalVariables.LOGGER.error("Cannot update modpack, secret is null");
            return;
        }
        new ScreenManager().download(this.downloadManager, this.getModpackName());
        long start = System.currentTimeMillis();
        try {
            this.modpackDir = ModpackUtils.renameModpackDir(this.serverModpackContent, this.modpackDir);
            this.modpackContentFile = this.modpackDir.resolve(this.modpackContentFile.getFileName());
            Iterator<Jsons.ModpackContentFields.ModpackContentItem> iterator = this.serverModpackContent.list.iterator();
            int skippedDownloadedFiles = 0;
            int skippedEditableFiles = 0;
            while (iterator.hasNext()) {
                Jsons.ModpackContentFields.ModpackContentItem modpackContentField = iterator.next();
                String file = modpackContentField.file;
                String serverSHA1 = modpackContentField.sha1;
                Object path = CustomFileUtils.getPath(this.modpackDir, file);
                if (Files.exists((Path)path, new LinkOption[0]) && modpackContentField.editable) {
                    ++skippedEditableFiles;
                    GlobalVariables.LOGGER.info("Skipping editable file: {}", (Object)file);
                    iterator.remove();
                    continue;
                }
                if (!Files.exists((Path)path, new LinkOption[0])) {
                    path = CustomFileUtils.getPathFromCWD(file);
                }
                if (!Files.exists((Path)path, new LinkOption[0]) || !Objects.equals(serverSHA1, CustomFileUtils.getHash((Path)path))) continue;
                ++skippedDownloadedFiles;
                iterator.remove();
            }
            if (skippedEditableFiles > 0) {
                GlobalVariables.LOGGER.info("Skipped {} editable files", (Object)skippedEditableFiles);
            }
            if (skippedDownloadedFiles > 0) {
                GlobalVariables.LOGGER.info("Skipped {} already downloaded files", (Object)skippedDownloadedFiles);
            }
            long startFetching = System.currentTimeMillis();
            LinkedList<FetchManager.FetchData> fetchDatas = new LinkedList<FetchManager.FetchData>();
            for (Jsons.ModpackContentFields.ModpackContentItem field : this.serverModpackContent.list) {
                this.totalBytesToDownload += Long.parseLong(field.size);
                String fileType = field.type;
                if (!fileType.equals("mod") && !fileType.equals("shader") && !fileType.equals("resourcepack")) continue;
                fetchDatas.add(new FetchManager.FetchData(field.file, field.sha1, field.murmur, field.size, fileType));
            }
            this.fetchManager = new FetchManager(fetchDatas);
            new ScreenManager().fetch(this.fetchManager);
            this.fetchManager.fetch();
            GlobalVariables.LOGGER.info("Finished fetching urls in {}ms", (Object)(System.currentTimeMillis() - startFetching));
            this.newDownloadedFiles.clear();
            int wholeQueue = this.serverModpackContent.list.size();
            if (wholeQueue > 0) {
                GlobalVariables.LOGGER.info("In queue left {} files to download ({}MB)", (Object)wholeQueue, (Object)(this.totalBytesToDownload / 1024L / 1024L));
                DownloadClient downloadClient = DownloadClient.tryCreate(this.modpackAddresses, this.modpackSecret.secretBytes(), Math.min(wholeQueue, 5), ModpackUtils.userValidationCallback(this.modpackAddresses.hostAddress, false));
                if (downloadClient == null) {
                    return;
                }
                this.downloadManager = new DownloadManager(this.totalBytesToDownload);
                new ScreenManager().download(this.downloadManager, this.getModpackName());
                this.downloadManager.attachDownloadClient(downloadClient);
                LinkedList<Jsons.ModpackContentFields.ModpackContentItem> randomizedList = new LinkedList<Jsons.ModpackContentFields.ModpackContentItem>(this.serverModpackContent.list);
                Collections.shuffle(randomizedList);
                for (Jsons.ModpackContentFields.ModpackContentItem item2 : randomizedList) {
                    String fileName = item2.file;
                    String serverSHA1 = item2.sha1;
                    Path downloadFile = CustomFileUtils.getPath(this.modpackDir, fileName);
                    if (!Files.exists(downloadFile, new LinkOption[0])) {
                        this.newDownloadedFiles.add(fileName);
                    }
                    ArrayList<String> urls = new ArrayList<String>();
                    if (this.fetchManager.getFetchDatas().containsKey(item2.sha1)) {
                        urls.addAll(this.fetchManager.getFetchDatas().get(item2.sha1).fetchedData().urls());
                    }
                    Runnable failureCallback = () -> this.failedDownloads.put(item2, urls);
                    Runnable successCallback = () -> {
                        List<Object> mainPageUrls = new LinkedList();
                        if (this.fetchManager != null && this.fetchManager.getFetchDatas().get(item.sha1) != null) {
                            mainPageUrls = this.fetchManager.getFetchDatas().get(item.sha1).fetchedData().mainPageUrls();
                        }
                        this.changelogs.changesAddedList.put(downloadFile.getFileName().toString(), mainPageUrls);
                    };
                    this.downloadManager.download(downloadFile, serverSHA1, urls, successCallback, failureCallback);
                }
                this.downloadManager.joinAll();
                GlobalVariables.LOGGER.info("Finished downloading files in {}ms", (Object)(System.currentTimeMillis() - startFetching));
                if (this.downloadManager.isCanceled()) {
                    GlobalVariables.LOGGER.warn("Download canceled");
                    return;
                }
                this.downloadManager.cancelAllAndShutdown();
                this.totalBytesToDownload = 0L;
                HashMap hashesToRefresh = new HashMap();
                HashMap<Jsons.ModpackContentFields.ModpackContentItem, List<String>> failedDownloadsSecMap = new HashMap<Jsons.ModpackContentFields.ModpackContentItem, List<String>>(this.failedDownloads);
                failedDownloadsSecMap.forEach((k, v) -> {
                    hashesToRefresh.put(k.file, k.sha1);
                    this.failedDownloads.remove(k);
                    this.totalBytesToDownload += Long.parseLong(k.size);
                });
                if (!hashesToRefresh.isEmpty()) {
                    GlobalVariables.LOGGER.warn("Failed to download {} files", (Object)hashesToRefresh.size());
                }
                if (!hashesToRefresh.isEmpty()) {
                    byte[][] hashesArray = (byte[][])hashesToRefresh.values().stream().map(String::getBytes).toArray(x$0 -> new byte[x$0][]);
                    GlobalVariables.LOGGER.warn("Trying to refresh the modpack content");
                    GlobalVariables.LOGGER.info("Sending hashes to refresh: {}", hashesToRefresh.values());
                    Optional<Jsons.ModpackContentFields> refreshedContentOptional = ModpackUtils.refreshServerModpackContent(this.modpackAddresses, this.modpackSecret, hashesArray, false);
                    if (refreshedContentOptional.isEmpty()) {
                        GlobalVariables.LOGGER.error("Failed to refresh the modpack content");
                    } else {
                        GlobalVariables.LOGGER.info("Successfully refreshed the modpack content");
                        Jsons.ModpackContentFields refreshedContent = refreshedContentOptional.get();
                        this.modpackContentJson = ConfigTools.GSON.toJson((Object)refreshedContent);
                        List<Jsons.ModpackContentFields.ModpackContentItem> refreshedFilteredList = refreshedContent.list.stream().filter(item -> hashesToRefresh.containsKey(item.file)).toList();
                        downloadClient = DownloadClient.tryCreate(this.modpackAddresses, this.modpackSecret.secretBytes(), Math.min(refreshedFilteredList.size(), 5), ModpackUtils.userValidationCallback(this.modpackAddresses.hostAddress, false));
                        if (downloadClient == null) {
                            return;
                        }
                        this.downloadManager = new DownloadManager(this.totalBytesToDownload);
                        new ScreenManager().download(this.downloadManager, this.getModpackName());
                        this.downloadManager.attachDownloadClient(downloadClient);
                        randomizedList = new LinkedList<Jsons.ModpackContentFields.ModpackContentItem>(refreshedFilteredList);
                        Collections.shuffle(randomizedList);
                        for (Jsons.ModpackContentFields.ModpackContentItem item3 : randomizedList) {
                            String fileName = item3.file;
                            String serverSHA1 = item3.sha1;
                            Path downloadFile = CustomFileUtils.getPath(this.modpackDir, fileName);
                            GlobalVariables.LOGGER.info("Retrying to download {} from {}", (Object)fileName, (Object)this.modpackAddresses.hostAddress.getHostName());
                            Runnable failureCallback = () -> this.failedDownloads.put(item3, List.of());
                            Runnable successCallback = () -> this.changelogs.changesAddedList.put(downloadFile.getFileName().toString(), null);
                            this.downloadManager.download(downloadFile, serverSHA1, List.of(), successCallback, failureCallback);
                        }
                        this.downloadManager.joinAll();
                        if (this.downloadManager.isCanceled()) {
                            GlobalVariables.LOGGER.warn("Download canceled");
                            return;
                        }
                        this.downloadManager.cancelAllAndShutdown();
                        GlobalVariables.LOGGER.info("Finished refreshed downloading files in {}ms", (Object)(System.currentTimeMillis() - startFetching));
                    }
                }
            }
            GlobalVariables.LOGGER.info("Done, saving {}", (Object)this.modpackContentFile);
            Files.writeString(this.modpackContentFile, (CharSequence)this.modpackContentJson, new OpenOption[0]);
            Path cwd = Path.of(System.getProperty("user.dir"), new String[0]);
            CustomFileUtils.deleteDummyFiles(cwd, this.serverModpackContent.list);
            if (GlobalVariables.preload.booleanValue()) {
                GlobalVariables.LOGGER.info("Update completed! Took: {}ms", (Object)(System.currentTimeMillis() - start));
                this.CheckAndLoadModpack();
            } else if (this.failedDownloads.isEmpty()) {
                boolean requiredRestart = this.applyModpack();
                GlobalVariables.LOGGER.info("Update completed! Required restart: {} Took: {}ms", (Object)requiredRestart, (Object)(System.currentTimeMillis() - start));
                UpdateType updateType = this.fullDownload ? UpdateType.FULL : UpdateType.UPDATE;
                new ReLauncher(this.modpackDir, updateType, this.changelogs).restart(false, new Runnable[0]);
            } else {
                StringBuilder failedFiles = new StringBuilder();
                for (Map.Entry<Jsons.ModpackContentFields.ModpackContentItem, List<String>> download : this.failedDownloads.entrySet()) {
                    Jsons.ModpackContentFields.ModpackContentItem item4 = download.getKey();
                    List<String> urls = download.getValue();
                    GlobalVariables.LOGGER.error("{}{}", (Object)("Failed to download: " + item4.file + " from "), urls);
                    failedFiles.append(item4.file);
                }
                new ScreenManager().error("automodpack.error.files", "Failed to download: " + String.valueOf(failedFiles), "automodpack.error.logs");
                GlobalVariables.LOGGER.error("Update failed successfully! Try again! Took: {}ms", (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (ConnectException | SocketTimeoutException e) {
            GlobalVariables.LOGGER.error("{} is not responding", (Object)("Modpack host of " + String.valueOf(this.modpackAddresses.hostAddress)), (Object)e);
        }
        catch (InterruptedException e) {
            GlobalVariables.LOGGER.info("Interrupted the download");
        }
        catch (Exception e) {
            new ScreenManager().error("automodpack.error.critical", "\"" + e.getMessage() + "\"", "automodpack.error.logs");
            e.printStackTrace();
        }
    }

    private boolean applyModpack() throws Exception {
        ModpackUtils.selectModpack(this.modpackDir, this.modpackAddresses, this.newDownloadedFiles);
        try {
            SecretsStore.saveClientSecret(GlobalVariables.clientConfig.selectedModpack, this.modpackSecret);
        }
        catch (IllegalArgumentException e) {
            GlobalVariables.LOGGER.error("Failed to save client secret", (Throwable)e);
        }
        Jsons.ModpackContentFields modpackContent = ConfigTools.loadModpackContent(this.modpackContentFile);
        if (modpackContent == null) {
            throw new IllegalStateException("Failed to load modpack content");
        }
        if (this.serverModpackContent != null) {
            if (this.serverModpackContent.loader != null && this.serverModpackContent.loaderVersion != null && this.serverModpackContent.loader.equals(GlobalVariables.LOADER)) {
                List<String> UID = switch (GlobalVariables.LOADER) {
                    case "fabric" -> MmcPackMagic.FABRIC_LOADER_UID;
                    case "quilt" -> MmcPackMagic.QUILT_LOADER_UID;
                    case "forge" -> MmcPackMagic.FORGE_LOADER_UID;
                    case "neoforge" -> MmcPackMagic.NEOFORGE_LOADER_UID;
                    default -> null;
                };
                MmcPackMagic.changeVersion(UID, this.serverModpackContent.loaderVersion);
            }
            if (this.serverModpackContent.mcVersion != null) {
                MmcPackMagic.changeVersion(MmcPackMagic.MINECRAFT_UID, this.serverModpackContent.mcVersion);
            }
        }
        List<FileInspection.Mod> conflictingNestedMods = GlobalVariables.MODPACK_LOADER.getModpackNestedConflicts(this.modpackDir);
        boolean needsRestart0 = this.deleteNonModpackFiles(modpackContent);
        Set<String> workaroundMods = new WorkaroundUtil(this.modpackDir).getWorkaroundMods(modpackContent);
        Set<String> filesNotToCopy = this.getFilesNotToCopy(modpackContent.list, workaroundMods);
        boolean needsRestart1 = ModpackUtils.correctFilesLocations(this.modpackDir, modpackContent, filesNotToCopy);
        HashSet modpackMods = new HashSet();
        ArrayList<FileInspection.Mod> modpackModList = new ArrayList<FileInspection.Mod>();
        Path modpackModsDir = this.modpackDir.resolve("mods");
        if (Files.exists(modpackModsDir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(modpackModsDir);){
                stream.forEach(path -> {
                    modpackMods.add(path);
                    FileInspection.Mod mod = FileInspection.getMod(path);
                    if (mod != null) {
                        modpackModList.add(mod);
                    }
                });
            }
        }
        ArrayList<FileInspection.Mod> standardModList = new ArrayList<FileInspection.Mod>();
        Path standardModsDir = GlobalVariables.MODS_DIR;
        if (Files.exists(standardModsDir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(standardModsDir);){
                stream.forEach(path -> {
                    FileInspection.Mod mod = FileInspection.getMod(path);
                    if (mod != null) {
                        standardModList.add(mod);
                    }
                });
            }
        }
        if (!(conflictingNestedMods = conflictingNestedMods.stream().filter(conflictingMod -> modpackMods.contains(conflictingMod.modPath())).toList()).isEmpty()) {
            GlobalVariables.LOGGER.warn("Found conflicting nested mods: {}", conflictingNestedMods);
        }
        boolean needsRestart2 = ModpackUtils.fixNestedMods(conflictingNestedMods, standardModList);
        Set<String> ignoredFiles = ModpackUtils.getIgnoredFiles(conflictingNestedMods, workaroundMods);
        boolean needsRestart3 = ModpackUtils.removeDupeMods(this.modpackDir, standardModList, modpackModList, ignoredFiles, workaroundMods);
        return needsRestart0 || needsRestart1 || needsRestart2 || needsRestart3;
    }

    private Set<String> getFilesNotToCopy(Set<Jsons.ModpackContentFields.ModpackContentItem> modpackContentItems, Set<String> workaroundMods) {
        HashSet<String> filesNotToCopy = new HashSet<String>();
        for (Jsons.ModpackContentFields.ModpackContentItem modpackContentItem : modpackContentItems) {
            if (modpackContentItem.editable && !this.newDownloadedFiles.contains(modpackContentItem.file)) {
                filesNotToCopy.add(modpackContentItem.file);
            }
            if (!modpackContentItem.type.equals("mod") || workaroundMods.contains(modpackContentItem.file)) continue;
            filesNotToCopy.add(modpackContentItem.file);
        }
        return filesNotToCopy;
    }

    private boolean deleteNonModpackFiles(Jsons.ModpackContentFields modpackContent) throws IOException {
        List<Path> pathList;
        List<String> modpackFiles = modpackContent.list.stream().map(modpackContentField -> modpackContentField.file).toList();
        try (Stream<Path> pathStream = Files.walk(this.modpackDir, new FileVisitOption[0]);){
            pathList = pathStream.toList();
        }
        HashSet<Path> parentPaths = new HashSet<Path>();
        boolean needsRestart = false;
        for (Path path : pathList) {
            String formattedFile;
            if (Files.isDirectory(path, new LinkOption[0]) || path.equals(this.modpackContentFile) || modpackFiles.contains(formattedFile = CustomFileUtils.formatPath(path, this.modpackDir))) continue;
            Path runPath = CustomFileUtils.getPathFromCWD(formattedFile);
            if (CustomFileUtils.hashCompare(path, runPath)) {
                GlobalVariables.LOGGER.info("Deleting {} and {}", (Object)path, (Object)runPath);
                parentPaths.add(runPath.getParent());
                CustomFileUtils.forceDelete(runPath);
                needsRestart = true;
            } else {
                GlobalVariables.LOGGER.info("Deleting {}", (Object)path);
            }
            parentPaths.add(path.getParent());
            CustomFileUtils.forceDelete(path);
            this.changelogs.changesDeletedList.put(path.getFileName().toString(), null);
        }
        for (Path parentPath : parentPaths) {
            this.deleteEmptyParentDirectoriesRecursively(parentPath);
        }
        return needsRestart;
    }

    private void deleteEmptyParentDirectoriesRecursively(Path directory) throws IOException {
        if (directory == null || !CustomFileUtils.isEmptyDirectory(directory)) {
            return;
        }
        GlobalVariables.LOGGER.info("Deleting empty directory {}", (Object)directory);
        CustomFileUtils.forceDelete(directory);
        this.deleteEmptyParentDirectoriesRecursively(directory.getParent());
    }
}

