/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.crypto;

import am_libs.org.bouncycastle.crypto.BlockCipher;
import am_libs.org.bouncycastle.crypto.BufferedBlockCipher;
import am_libs.org.bouncycastle.crypto.CipherParameters;
import am_libs.org.bouncycastle.crypto.DataLengthException;
import am_libs.org.bouncycastle.crypto.InvalidCipherTextException;
import am_libs.org.bouncycastle.crypto.MultiBlockCipher;
import am_libs.org.bouncycastle.crypto.OutputLengthException;
import am_libs.org.bouncycastle.crypto.StreamCipher;

public class DefaultBufferedBlockCipher
extends BufferedBlockCipher {
    protected byte[] buf;
    protected int bufOff;
    protected boolean forEncryption;
    protected BlockCipher cipher;
    protected MultiBlockCipher mbCipher;
    protected boolean partialBlockOkay;
    protected boolean pgpCFB;

    protected DefaultBufferedBlockCipher() {
    }

    public DefaultBufferedBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        if (blockCipher instanceof MultiBlockCipher) {
            this.mbCipher = (MultiBlockCipher)blockCipher;
            this.buf = new byte[this.mbCipher.getMultiBlockSize()];
        } else {
            this.mbCipher = null;
            this.buf = new byte[blockCipher.getBlockSize()];
        }
        this.bufOff = 0;
        String string = blockCipher.getAlgorithmName();
        int n = string.indexOf(47) + 1;
        boolean bl = this.pgpCFB = n > 0 && string.startsWith("PGP", n);
        this.partialBlockOkay = this.pgpCFB || blockCipher instanceof StreamCipher ? true : n > 0 && string.startsWith("OpenPGP", n);
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.forEncryption = bl;
        this.reset();
        this.cipher.init(bl, cipherParameters);
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int getUpdateOutputSize(int n) {
        int n2 = n + this.bufOff;
        int n3 = this.pgpCFB ? (this.forEncryption ? n2 % this.buf.length - (this.cipher.getBlockSize() + 2) : n2 % this.buf.length) : n2 % this.buf.length;
        return n2 - n3;
    }

    @Override
    public int getOutputSize(int n) {
        if (this.pgpCFB && this.forEncryption) {
            return n + this.bufOff + (this.cipher.getBlockSize() + 2);
        }
        return n + this.bufOff;
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n) throws DataLengthException, IllegalStateException {
        int n2 = 0;
        this.buf[this.bufOff++] = by;
        if (this.bufOff == this.buf.length) {
            n2 = this.processBuffer(byArray, n);
        }
        return n2;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n4 = this.getBlockSize();
        int n5 = this.getUpdateOutputSize(n2);
        if (n5 > 0 && n3 + n5 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int n6 = 0;
        int n7 = this.buf.length - this.bufOff;
        if (n2 > n7) {
            if (this.bufOff != 0) {
                System.arraycopy(byArray, n, this.buf, this.bufOff, n7);
                n += n7;
                n2 -= n7;
            }
            if (byArray == byArray2) {
                byArray = new byte[n2];
                System.arraycopy(byArray2, n, byArray, 0, n2);
                n = 0;
            }
            if (this.bufOff != 0) {
                n6 += this.processBuffer(byArray2, n3);
            }
            if (this.mbCipher != null) {
                int n8 = n2 / this.mbCipher.getMultiBlockSize() * (this.mbCipher.getMultiBlockSize() / n4);
                if (n8 > 0) {
                    n6 += this.mbCipher.processBlocks(byArray, n, n8, byArray2, n3 + n6);
                    int n9 = n8 * n4;
                    n2 -= n9;
                    n += n9;
                }
            } else {
                while (n2 > this.buf.length) {
                    n6 += this.cipher.processBlock(byArray, n, byArray2, n3 + n6);
                    n2 -= n4;
                    n += n4;
                }
            }
        }
        System.arraycopy(byArray, n, this.buf, this.bufOff, n2);
        this.bufOff += n2;
        if (this.bufOff == this.buf.length) {
            n6 += this.processBuffer(byArray2, n3 + n6);
        }
        return n6;
    }

    private int processBuffer(byte[] byArray, int n) {
        this.bufOff = 0;
        if (this.mbCipher != null) {
            return this.mbCipher.processBlocks(this.buf, 0, this.buf.length / this.mbCipher.getBlockSize(), byArray, n);
        }
        return this.cipher.processBlock(this.buf, 0, byArray, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] byArray, int n) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        try {
            int n2;
            int n3 = 0;
            if (n + this.bufOff > byArray.length) {
                throw new OutputLengthException("output buffer too short for doFinal()");
            }
            if (this.bufOff != 0) {
                n2 = 0;
                if (this.mbCipher != null) {
                    int n4 = this.bufOff / this.mbCipher.getBlockSize();
                    n3 += this.mbCipher.processBlocks(this.buf, 0, n4, byArray, n);
                    n2 = n4 * this.mbCipher.getBlockSize();
                }
                if (this.bufOff != n2) {
                    if (!this.partialBlockOkay) {
                        throw new DataLengthException("data not block size aligned");
                    }
                    this.cipher.processBlock(this.buf, n2, this.buf, n2);
                    System.arraycopy(this.buf, n2, byArray, n + n3, this.bufOff - n2);
                    n3 += this.bufOff - n2;
                    this.bufOff = 0;
                }
            }
            n2 = n3;
            return n2;
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.buf.length; ++i) {
            this.buf[i] = 0;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

