/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.pqc.jcajce.provider.lms;

import am_libs.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import am_libs.org.bouncycastle.crypto.CipherParameters;
import am_libs.org.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import am_libs.org.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import am_libs.org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import am_libs.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import am_libs.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import am_libs.org.bouncycastle.pqc.jcajce.interfaces.LMSKey;
import am_libs.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BCLMSPublicKey
implements PublicKey,
LMSKey {
    private static final long serialVersionUID = -5617456225328969766L;
    private transient LMSKeyParameters keyParams;

    public BCLMSPublicKey(LMSKeyParameters lMSKeyParameters) {
        this.keyParams = lMSKeyParameters instanceof HSSPublicKeyParameters ? lMSKeyParameters : new HSSPublicKeyParameters(1, (LMSPublicKeyParameters)lMSKeyParameters);
    }

    public BCLMSPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.keyParams = (LMSKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    @Override
    public final String getAlgorithm() {
        return "LMS";
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.keyParams);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCLMSPublicKey) {
            BCLMSPublicKey bCLMSPublicKey = (BCLMSPublicKey)object;
            try {
                return Arrays.areEqual(this.keyParams.getEncoded(), bCLMSPublicKey.keyParams.getEncoded());
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return Arrays.hashCode(this.keyParams.getEncoded());
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    @Override
    public int getLevels() {
        if (this.keyParams instanceof LMSPublicKeyParameters) {
            return 1;
        }
        return ((HSSPublicKeyParameters)this.keyParams).getL();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

