/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;

class CustomizableTrustManager
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager defaultTrustManager;
    private final X509ExtendedTrustManager trustedCertificatesTrustManager;
    private final Consumer<X509Certificate[]> onValidating;

    public CustomizableTrustManager(KeyStore trustedCertificates, Consumer<X509Certificate[]> onValidating) throws KeyStoreException {
        TrustManagerFactory trustManagerFactory;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to create a TrustManagerFactory with the default algorithm.", e);
        }
        try {
            trustManagerFactory.init((KeyStore)null);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Failed to initialize a TrustManagerFactory.", e);
        }
        this.defaultTrustManager = CustomizableTrustManager.getX509ExtendedTrustManager(trustManagerFactory);
        X509ExtendedTrustManager trustedCertificatesTrustManager = null;
        if (trustedCertificates.size() > 0) {
            try {
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Failed to create a TrustManagerFactory with the default algorithm.", e);
            }
            trustManagerFactory.init(trustedCertificates);
            trustedCertificatesTrustManager = CustomizableTrustManager.getX509ExtendedTrustManager(trustManagerFactory);
        }
        this.trustedCertificatesTrustManager = trustedCertificatesTrustManager;
        this.onValidating = onValidating;
    }

    private static X509ExtendedTrustManager getX509ExtendedTrustManager(TrustManagerFactory trustManagerFactory) {
        X509ExtendedTrustManager trustedCertificatesTrustManager = null;
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
            trustedCertificatesTrustManager = (X509ExtendedTrustManager)trustManager;
            break;
        }
        if (trustedCertificatesTrustManager == null) {
            throw new RuntimeException("Failed to create an extended trust manager.");
        }
        return trustedCertificatesTrustManager;
    }

    private X509Certificate[] mergeCertificates() {
        ArrayList<X509Certificate> resultingCerts = new ArrayList<X509Certificate>(Arrays.asList(this.defaultTrustManager.getAcceptedIssuers()));
        if (this.trustedCertificatesTrustManager != null) {
            resultingCerts.addAll(Arrays.asList(this.trustedCertificatesTrustManager.getAcceptedIssuers()));
        }
        return resultingCerts.toArray(new X509Certificate[0]);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.onValidating.accept(chain);
        try {
            this.defaultTrustManager.checkClientTrusted(chain, authType);
        }
        catch (CertificateException e) {
            if (this.trustedCertificatesTrustManager != null) {
                this.trustedCertificatesTrustManager.checkClientTrusted(chain, authType);
            }
            throw e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.onValidating.accept(chain);
        try {
            this.defaultTrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            if (this.trustedCertificatesTrustManager != null) {
                this.trustedCertificatesTrustManager.checkServerTrusted(chain, authType);
            }
            throw e;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.mergeCertificates();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket checkedSocket) throws CertificateException {
        try {
            this.defaultTrustManager.checkClientTrusted(chain, authType, checkedSocket);
        }
        catch (CertificateException e) {
            if (this.trustedCertificatesTrustManager != null) {
                this.trustedCertificatesTrustManager.checkClientTrusted(chain, authType);
            }
            throw e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket checkedSocket) throws CertificateException {
        this.onValidating.accept(chain);
        try {
            this.defaultTrustManager.checkServerTrusted(chain, authType, checkedSocket);
        }
        catch (CertificateException e) {
            if (this.trustedCertificatesTrustManager != null) {
                this.trustedCertificatesTrustManager.checkServerTrusted(chain, authType);
            }
            throw e;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        try {
            this.defaultTrustManager.checkClientTrusted(chain, authType, sslEngine);
        }
        catch (CertificateException e) {
            if (this.trustedCertificatesTrustManager != null) {
                this.trustedCertificatesTrustManager.checkClientTrusted(chain, authType);
            }
            throw e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.onValidating.accept(chain);
        try {
            this.defaultTrustManager.checkServerTrusted(chain, authType, sslEngine);
        }
        catch (CertificateException e) {
            if (this.trustedCertificatesTrustManager != null) {
                this.trustedCertificatesTrustManager.checkServerTrusted(chain, authType);
            }
            throw e;
        }
    }
}

