/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.apache.hc.core5.http2.impl.nio;

import am_libs.org.apache.hc.core5.annotation.Contract;
import am_libs.org.apache.hc.core5.annotation.Internal;
import am_libs.org.apache.hc.core5.annotation.ThreadingBehavior;
import am_libs.org.apache.hc.core5.concurrent.FutureCallback;
import am_libs.org.apache.hc.core5.http.impl.nio.ClientHttp1IOEventHandler;
import am_libs.org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import am_libs.org.apache.hc.core5.reactor.ProtocolIOSession;
import am_libs.org.apache.hc.core5.reactor.ProtocolUpgradeHandler;
import am_libs.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ClientHttp1UpgradeHandler
implements ProtocolUpgradeHandler {
    private final ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory;

    public ClientHttp1UpgradeHandler(ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory) {
        this.http1StreamHandlerFactory = Args.notNull(http1StreamHandlerFactory, "HTTP/1.1 stream handler factory");
    }

    @Override
    public void upgrade(ProtocolIOSession ioSession, FutureCallback<ProtocolIOSession> callback) {
        ClientHttp1IOEventHandler eventHandler = new ClientHttp1IOEventHandler(this.http1StreamHandlerFactory.create(ioSession));
        ioSession.upgrade(eventHandler);
        try {
            eventHandler.connected(ioSession);
            if (callback != null) {
                callback.completed(ioSession);
            }
        }
        catch (IOException ex) {
            eventHandler.exception(ioSession, ex);
        }
    }
}

