/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.pqc.jcajce.provider.xmss;

import am_libs.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import am_libs.org.bouncycastle.asn1.ASN1Set;
import am_libs.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import am_libs.org.bouncycastle.crypto.CipherParameters;
import am_libs.org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import am_libs.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import am_libs.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import am_libs.org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import am_libs.org.bouncycastle.pqc.jcajce.interfaces.XMSSMTPrivateKey;
import am_libs.org.bouncycastle.pqc.jcajce.provider.xmss.DigestUtil;
import am_libs.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BCXMSSMTPrivateKey
implements PrivateKey,
XMSSMTPrivateKey {
    private static final long serialVersionUID = 7682140473044521395L;
    private transient ASN1ObjectIdentifier treeDigest;
    private transient XMSSMTPrivateKeyParameters keyParams;
    private transient ASN1Set attributes;

    public BCXMSSMTPrivateKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters) {
        this.treeDigest = aSN1ObjectIdentifier;
        this.keyParams = xMSSMTPrivateKeyParameters;
    }

    public BCXMSSMTPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        XMSSMTKeyParams xMSSMTKeyParams = XMSSMTKeyParams.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        this.treeDigest = xMSSMTKeyParams.getTreeDigest().getAlgorithm();
        this.keyParams = (XMSSMTPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    @Override
    public long getIndex() {
        if (this.getUsagesRemaining() == 0L) {
            throw new IllegalStateException("key exhausted");
        }
        return this.keyParams.getIndex();
    }

    @Override
    public long getUsagesRemaining() {
        return this.keyParams.getUsagesRemaining();
    }

    @Override
    public XMSSMTPrivateKey extractKeyShard(int n) {
        return new BCXMSSMTPrivateKey(this.treeDigest, this.keyParams.extractKeyShard(n));
    }

    @Override
    public String getAlgorithm() {
        return "XMSSMT";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.keyParams, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSMTPrivateKey) {
            BCXMSSMTPrivateKey bCXMSSMTPrivateKey = (BCXMSSMTPrivateKey)object;
            return this.treeDigest.equals(bCXMSSMTPrivateKey.treeDigest) && Arrays.areEqual(this.keyParams.toByteArray(), bCXMSSMTPrivateKey.keyParams.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode(this.keyParams.toByteArray());
    }

    ASN1ObjectIdentifier getTreeDigestOID() {
        return this.treeDigest;
    }

    @Override
    public int getHeight() {
        return this.keyParams.getParameters().getHeight();
    }

    @Override
    public int getLayers() {
        return this.keyParams.getParameters().getLayers();
    }

    @Override
    public String getTreeDigest() {
        return DigestUtil.getXMSSDigestName(this.treeDigest);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

