/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.pqc.crypto.ntru;

import am_libs.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import am_libs.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import am_libs.org.bouncycastle.crypto.KeyGenerationParameters;
import am_libs.org.bouncycastle.pqc.crypto.ntru.NTRUKeyGenerationParameters;
import am_libs.org.bouncycastle.pqc.crypto.ntru.NTRUOWCPA;
import am_libs.org.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import am_libs.org.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import am_libs.org.bouncycastle.pqc.crypto.ntru.NTRUPublicKeyParameters;
import am_libs.org.bouncycastle.pqc.crypto.ntru.OWCPAKeyPair;
import am_libs.org.bouncycastle.pqc.math.ntru.parameters.NTRUParameterSet;
import am_libs.org.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class NTRUKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRUKeyGenerationParameters params;
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.params = (NTRUKeyGenerationParameters)keyGenerationParameters;
        this.random = keyGenerationParameters.getRandom();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        NTRUParameters nTRUParameters = this.params.getParameters();
        NTRUParameterSet nTRUParameterSet = nTRUParameters.getParameterSet();
        byte[] byArray = new byte[nTRUParameterSet.sampleFgBytes()];
        this.random.nextBytes(byArray);
        NTRUOWCPA nTRUOWCPA = new NTRUOWCPA(nTRUParameterSet);
        OWCPAKeyPair oWCPAKeyPair = nTRUOWCPA.keypair(byArray);
        byte[] byArray2 = oWCPAKeyPair.publicKey;
        byte[] byArray3 = new byte[nTRUParameterSet.prfKeyBytes()];
        this.random.nextBytes(byArray3);
        byte[] byArray4 = Arrays.concatenate(oWCPAKeyPair.privateKey, byArray3);
        return new AsymmetricCipherKeyPair(new NTRUPublicKeyParameters(nTRUParameters, byArray2), new NTRUPrivateKeyParameters(nTRUParameters, byArray4));
    }
}

