/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.pqc.jcajce.provider.ntruprime;

import amp_libs.org.bouncycastle.crypto.SecretWithEncapsulation;
import amp_libs.org.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import amp_libs.org.bouncycastle.jcajce.spec.KEMExtractSpec;
import amp_libs.org.bouncycastle.jcajce.spec.KEMGenerateSpec;
import amp_libs.org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeKEMExtractor;
import amp_libs.org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeKEMGenerator;
import amp_libs.org.bouncycastle.pqc.jcajce.provider.ntruprime.BCNTRULPRimePrivateKey;
import amp_libs.org.bouncycastle.pqc.jcajce.provider.ntruprime.BCNTRULPRimePublicKey;
import amp_libs.org.bouncycastle.util.Arrays;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;

public class NTRULPRimeKeyGeneratorSpi
extends KeyGeneratorSpi {
    private KEMGenerateSpec genSpec;
    private SecureRandom random;
    private KEMExtractSpec extSpec;

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.random = secureRandom;
        if (algorithmParameterSpec instanceof KEMGenerateSpec) {
            this.genSpec = (KEMGenerateSpec)algorithmParameterSpec;
            this.extSpec = null;
        } else if (algorithmParameterSpec instanceof KEMExtractSpec) {
            this.genSpec = null;
            this.extSpec = (KEMExtractSpec)algorithmParameterSpec;
        } else {
            throw new InvalidAlgorithmParameterException("unknown spec");
        }
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.genSpec != null) {
            BCNTRULPRimePublicKey bCNTRULPRimePublicKey = (BCNTRULPRimePublicKey)this.genSpec.getPublicKey();
            NTRULPRimeKEMGenerator nTRULPRimeKEMGenerator = new NTRULPRimeKEMGenerator(this.random);
            SecretWithEncapsulation secretWithEncapsulation = nTRULPRimeKEMGenerator.generateEncapsulated(bCNTRULPRimePublicKey.getKeyParams());
            SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation(new SecretKeySpec(secretWithEncapsulation.getSecret(), this.genSpec.getKeyAlgorithmName()), secretWithEncapsulation.getEncapsulation());
            try {
                secretWithEncapsulation.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                throw new IllegalStateException("key cleanup failed");
            }
            return secretKeyWithEncapsulation;
        }
        BCNTRULPRimePrivateKey bCNTRULPRimePrivateKey = (BCNTRULPRimePrivateKey)this.extSpec.getPrivateKey();
        NTRULPRimeKEMExtractor nTRULPRimeKEMExtractor = new NTRULPRimeKEMExtractor(bCNTRULPRimePrivateKey.getKeyParams());
        byte[] byArray = this.extSpec.getEncapsulation();
        byte[] byArray2 = nTRULPRimeKEMExtractor.extractSecret(byArray);
        SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation(new SecretKeySpec(byArray2, this.extSpec.getKeyAlgorithmName()), byArray);
        Arrays.clear(byArray2);
        return secretKeyWithEncapsulation;
    }
}

