/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.jcajce.provider.symmetric;

import amp_libs.org.bouncycastle.crypto.BufferedBlockCipher;
import amp_libs.org.bouncycastle.crypto.CipherKeyGenerator;
import amp_libs.org.bouncycastle.crypto.engines.GOST3412_2015Engine;
import amp_libs.org.bouncycastle.crypto.macs.CMac;
import amp_libs.org.bouncycastle.crypto.modes.G3413CBCBlockCipher;
import amp_libs.org.bouncycastle.crypto.modes.G3413CFBBlockCipher;
import amp_libs.org.bouncycastle.crypto.modes.G3413CTRBlockCipher;
import amp_libs.org.bouncycastle.crypto.modes.G3413OFBBlockCipher;
import amp_libs.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import amp_libs.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import amp_libs.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import amp_libs.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import amp_libs.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public class GOST3412_2015 {

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new G3413CBCBlockCipher(new GOST3412_2015Engine()), false, 128);
        }
    }

    public static class CTR
    extends BaseBlockCipher {
        public CTR() {
            super(new BufferedBlockCipher(new G3413CTRBlockCipher(new GOST3412_2015Engine())), true, 64);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new GOST3412_2015Engine());
        }
    }

    public static class GCFB
    extends BaseBlockCipher {
        public GCFB() {
            super(new BufferedBlockCipher(new G3413CFBBlockCipher(new GOST3412_2015Engine())), false, 128);
        }
    }

    public static class GCFB8
    extends BaseBlockCipher {
        public GCFB8() {
            super(new BufferedBlockCipher(new G3413CFBBlockCipher(new GOST3412_2015Engine(), 8)), false, 128);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            this(256);
        }

        public KeyGen(int n) {
            super("GOST3412-2015", n, new CipherKeyGenerator());
        }
    }

    public static class Mac
    extends BaseMac {
        public Mac() {
            super(new CMac(new GOST3412_2015Engine()));
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = GOST3412_2015.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.GOST3412-2015", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("Cipher.GOST3412-2015/CFB", PREFIX + "$GCFB");
            configurableProvider.addAlgorithm("Cipher.GOST3412-2015/CFB8", PREFIX + "$GCFB8");
            configurableProvider.addAlgorithm("Cipher.GOST3412-2015/OFB", PREFIX + "$OFB");
            configurableProvider.addAlgorithm("Cipher.GOST3412-2015/CBC", PREFIX + "$CBC");
            configurableProvider.addAlgorithm("Cipher.GOST3412-2015/CTR", PREFIX + "$CTR");
            configurableProvider.addAlgorithm("KeyGenerator.GOST3412-2015", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("Mac.GOST3412MAC", PREFIX + "$Mac");
            configurableProvider.addAlgorithm("Alg.Alias.Mac.GOST3412-2015", "GOST3412MAC");
        }
    }

    public static class OFB
    extends BaseBlockCipher {
        public OFB() {
            super(new BufferedBlockCipher(new G3413OFBBlockCipher(new GOST3412_2015Engine())), false, 128);
        }
    }
}

