/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.crypto.generators;

import am_libs.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import am_libs.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import am_libs.org.bouncycastle.crypto.CryptoServicePurpose;
import am_libs.org.bouncycastle.crypto.CryptoServicesRegistrar;
import am_libs.org.bouncycastle.crypto.KeyGenerationParameters;
import am_libs.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import am_libs.org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import am_libs.org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import java.security.SecureRandom;

public class Ed448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("Ed448KeyGen", 224, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed448PrivateKeyParameters ed448PrivateKeyParameters = new Ed448PrivateKeyParameters(this.random);
        Ed448PublicKeyParameters ed448PublicKeyParameters = ed448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(ed448PublicKeyParameters, ed448PrivateKeyParameters);
    }
}

