/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.dvcs;

import amp_libs.org.bouncycastle.asn1.ASN1Encodable;
import amp_libs.org.bouncycastle.asn1.ASN1OctetString;
import amp_libs.org.bouncycastle.asn1.ASN1Sequence;
import amp_libs.org.bouncycastle.asn1.cms.ContentInfo;
import amp_libs.org.bouncycastle.asn1.cms.SignedData;
import amp_libs.org.bouncycastle.asn1.dvcs.DVCSObjectIdentifiers;
import amp_libs.org.bouncycastle.cms.CMSSignedData;
import amp_libs.org.bouncycastle.dvcs.DVCSConstructionException;
import amp_libs.org.bouncycastle.dvcs.DVCSMessage;

public class DVCSResponse
extends DVCSMessage {
    private amp_libs.org.bouncycastle.asn1.dvcs.DVCSResponse asn1;

    public DVCSResponse(CMSSignedData cMSSignedData) throws DVCSConstructionException {
        this(SignedData.getInstance(cMSSignedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSResponse(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSResponseData.equals(contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Response");
        }
        try {
            this.asn1 = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? amp_libs.org.bouncycastle.asn1.dvcs.DVCSResponse.getInstance(contentInfo.getContent()) : amp_libs.org.bouncycastle.asn1.dvcs.DVCSResponse.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
        }
        catch (Exception exception) {
            throw new DVCSConstructionException("Unable to parse content: " + exception.getMessage(), exception);
        }
    }

    @Override
    public ASN1Encodable getContent() {
        return this.asn1;
    }
}

